/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.cairo.TableToken;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class Path
extends AbstractCharSink
implements Closeable,
LPSZ {
    public static final ThreadLocal<Path> PATH = new ThreadLocal<Path>(Path::new);
    public static final ThreadLocal<Path> PATH2 = new ThreadLocal<Path>(Path::new);
    public static final Closeable THREAD_LOCAL_CLEANER = Path::clearThreadLocals;
    private static final byte NULL = 0;
    private static final int OVERHEAD = 4;
    private static final ThreadLocal<StringSink> tlBuilder = new ThreadLocal<StringSink>(StringSink::new);
    private int capacity;
    private long headPtr;
    private long tailPtr;

    public Path() {
        this(255);
    }

    public Path(int capacity) {
        assert (capacity > 0);
        this.capacity = capacity;
        this.headPtr = this.tailPtr = Unsafe.malloc(capacity + 1, 24);
    }

    public static void clearThreadLocals() {
        Misc.free(PATH);
        Misc.free(PATH2);
    }

    public static Path getThreadLocal(CharSequence root) {
        return PATH.get().of(root);
    }

    public static Path getThreadLocal(Path root) {
        return PATH.get().of(root);
    }

    public static Path getThreadLocal2(CharSequence root) {
        return PATH2.get().of(root);
    }

    public Path $() {
        if (this.tailPtr == this.headPtr || Unsafe.getUnsafe().getByte(this.tailPtr) != 0) {
            Unsafe.getUnsafe().putByte(this.tailPtr, (byte)0);
        }
        return this;
    }

    public void $at(int index) {
        Unsafe.getUnsafe().putByte(this.headPtr + (long)index, (byte)0);
    }

    @Override
    public long address() {
        return this.headPtr;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public char charAt(int index) {
        return (char)Unsafe.getUnsafe().getByte(this.headPtr + (long)index);
    }

    @Override
    public void close() {
        if (this.headPtr != 0L) {
            Unsafe.free(this.headPtr, this.capacity + 1, 24);
            this.tailPtr = 0L;
            this.headPtr = 0L;
        }
    }

    public Path concat(CharSequence str) {
        return this.concat(str, 0, str.length());
    }

    public Path concat(TableToken token) {
        return this.concat(token.getDirName());
    }

    public Path concat(long pUtf8NameZ) {
        int b;
        this.ensureSeparator();
        long p = pUtf8NameZ;
        while ((b = Unsafe.getUnsafe().getByte(p++)) != 0) {
            int requiredCapacity = this.length();
            if (requiredCapacity + 4 >= this.capacity) {
                this.extend(requiredCapacity * 2 + 4);
            }
            Unsafe.getUnsafe().putByte(this.tailPtr++, (byte)(b == 47 && Os.isWindows() ? 92 : b));
        }
        return this;
    }

    public Path concat(CharSequence str, int from, int to) {
        this.ensureSeparator();
        this.encodeUtf8(str, from, to);
        return this;
    }

    @Override
    public void flush() {
        this.$();
    }

    @Override
    public final int length() {
        return (int)(this.tailPtr - this.headPtr);
    }

    public Path of(CharSequence str) {
        this.checkClosed();
        if (str == this) {
            this.tailPtr = this.headPtr + (long)str.length();
            return this;
        }
        this.tailPtr = this.headPtr;
        return this.concat(str);
    }

    public Path of(Path other) {
        return this.of((LPSZ)other);
    }

    public Path of(LPSZ other) {
        int len = other.length();
        if (this.headPtr == 0L) {
            this.headPtr = Unsafe.malloc(len + 1, 24);
            this.capacity = len;
        } else if (this.capacity < len) {
            this.extend(len);
        }
        if (len > 0) {
            Unsafe.getUnsafe().copyMemory(other.address(), this.headPtr, len);
        }
        this.tailPtr = this.headPtr + (long)len;
        return this;
    }

    public Path of(CharSequence str, int from, int to) {
        this.checkClosed();
        this.tailPtr = this.headPtr;
        return this.concat(str, from, to);
    }

    public Path parent() {
        if (this.tailPtr > this.headPtr) {
            long p = this.tailPtr - 1L;
            byte last = Unsafe.getUnsafe().getByte(p);
            if (last == Files.SEPARATOR || last == 0) {
                if (p < this.headPtr + 2L) {
                    return this;
                }
                --p;
            }
            while (p > this.headPtr && (char)Unsafe.getUnsafe().getByte(p) != Files.SEPARATOR) {
                --p;
            }
            this.tailPtr = p;
        }
        return this;
    }

    public void put(int index, char c) {
        Unsafe.getUnsafe().putByte(this.headPtr + (long)index, (byte)c);
    }

    @Override
    public Path put(CharSequence str) {
        int l = str.length();
        int requiredCapacity = this.length() + l;
        if (requiredCapacity > this.capacity) {
            this.extend(requiredCapacity);
        }
        Chars.asciiStrCpy(str, l, this.tailPtr);
        this.tailPtr += (long)l;
        return this;
    }

    @Override
    public CharSink put(CharSequence cs, int lo, int hi) {
        int l = hi - lo;
        int requiredCapacity = this.length() + l;
        if (requiredCapacity > this.capacity) {
            this.extend(requiredCapacity);
        }
        Chars.asciiStrCpy(cs, lo, l, this.tailPtr);
        this.tailPtr += (long)l;
        return this;
    }

    @Override
    public Path put(char c) {
        assert (c != '\u0000');
        int requiredCapacity = this.length() + 1;
        if (requiredCapacity >= this.capacity) {
            this.extend(requiredCapacity + 15);
        }
        Unsafe.getUnsafe().putByte(this.tailPtr++, (byte)c);
        return this;
    }

    @Override
    public Path put(int value) {
        super.put(value);
        return this;
    }

    @Override
    public Path put(long value) {
        super.put(value);
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        int requiredCapacity = this.length() + len;
        if (requiredCapacity >= this.capacity) {
            this.extend(requiredCapacity);
        }
        Chars.asciiCopyTo(chars, start, len, this.tailPtr);
        this.tailPtr += (long)len;
        return this;
    }

    @Override
    public void putUtf8Special(char c) {
        if (c == '/' && Os.isWindows()) {
            this.put('\\');
        } else {
            this.put(c);
        }
    }

    public Path seekZ() {
        for (int count = 0; count < this.capacity; ++count) {
            if (Unsafe.getUnsafe().getByte(this.headPtr + (long)count) != 0) continue;
            this.tailPtr = this.headPtr + (long)count;
            break;
        }
        return this;
    }

    public Path slash() {
        this.ensureSeparator();
        return this;
    }

    public Path slash$() {
        this.ensureSeparator();
        return this.$();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public void toSink(CharSink sink) {
        Chars.utf8Decode(this.headPtr, this.tailPtr, sink);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.headPtr != 0L) {
            StringSink b = tlBuilder.get();
            b.clear();
            this.toSink(b);
            return b.toString();
        }
        return "";
    }

    public Path trimTo(int len) {
        this.tailPtr = this.headPtr + (long)len;
        return this;
    }

    private void checkClosed() {
        if (this.headPtr == 0L) {
            this.headPtr = this.tailPtr = Unsafe.malloc(this.capacity + 1, 24);
        }
    }

    protected final void ensureSeparator() {
        if (this.tailPtr > this.headPtr && Unsafe.getUnsafe().getByte(this.tailPtr - 1L) != Files.SEPARATOR) {
            Unsafe.getUnsafe().putByte(this.tailPtr++, (byte)Files.SEPARATOR);
        }
    }

    void extend(int newCapacity) {
        assert (newCapacity > this.capacity);
        int len = this.length();
        this.headPtr = Unsafe.realloc(this.headPtr, this.capacity + 1, newCapacity + 1, 24);
        this.tailPtr = this.headPtr + (long)len;
        this.capacity = newCapacity;
    }
}

