/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.IOException;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.AccessClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.client.impl.request.BasicAuthRequestConfig;
import org.apache.nifi.registry.client.impl.request.BearerTokenRequestConfig;

public class JerseyAccessClient
extends AbstractJerseyClient
implements AccessClient {
    private final WebTarget accessTarget;

    public JerseyAccessClient(WebTarget baseTarget) {
        super(null);
        this.accessTarget = baseTarget.path("/access");
    }

    @Override
    public String getToken(String username, String password) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("Username is required");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("Password is required");
        }
        return this.executeAction("Error performing login", () -> {
            WebTarget target = this.accessTarget.path("token/login");
            Invocation.Builder requestBuilder = this.getRequestBuilder(target);
            BasicAuthRequestConfig basicCredsConfig = new BasicAuthRequestConfig(username, password);
            Map<String, String> basicAuthHeaders = basicCredsConfig.getHeaders();
            basicAuthHeaders.entrySet().stream().forEach(e -> requestBuilder.header((String)e.getKey(), e.getValue()));
            return (String)requestBuilder.post(Entity.json(null), String.class);
        });
    }

    @Override
    public String getTokenFromKerberosTicket() throws NiFiRegistryException, IOException {
        return this.executeAction("Error performing kerberos login", () -> {
            WebTarget target = this.accessTarget.path("token/kerberos");
            return (String)this.getRequestBuilder(target).post(Entity.json(null), String.class);
        });
    }

    @Override
    public void logout(String token) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("Token is required");
        }
        this.executeAction("Error performing logout", () -> {
            WebTarget target = this.accessTarget.path("logout");
            Invocation.Builder requestBuilder = this.getRequestBuilder(target);
            BearerTokenRequestConfig tokenConfig = new BearerTokenRequestConfig(token);
            Map<String, String> bearerHeaders = tokenConfig.getHeaders();
            bearerHeaders.entrySet().stream().forEach(e -> requestBuilder.header((String)e.getKey(), e.getValue()));
            requestBuilder.delete();
            return null;
        });
    }
}

