/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.ConnectableComponentType;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedRemoteGroupPort;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.minifi.commons.schema.common.CollectionUtil;
import org.apache.nifi.minifi.commons.schema.common.StringUtil;

public class VersionedProcessGroupEnricher {
    public void enrich(VersionedProcessGroup versionedProcessGroup) {
        List<VersionedProcessGroup> allVersionedProcessGroups = VersionedProcessGroupEnricher.getAllVersionedProcessGroups(versionedProcessGroup);
        Set remoteProcessGroups = VersionedProcessGroupEnricher.getAll(allVersionedProcessGroups, VersionedProcessGroup::getRemoteProcessGroups).collect(Collectors.toSet());
        Map<String, String> connectableNameMap = VersionedProcessGroupEnricher.getAll(allVersionedProcessGroups, VersionedProcessGroup::getProcessors).collect(Collectors.toMap(VersionedComponent::getIdentifier, VersionedComponent::getName));
        HashMap<String, String> rpgIdToTargetIdMap = new HashMap<String, String>();
        for (VersionedRemoteProcessGroup remoteProcessGroup : remoteProcessGroups) {
            Set rpgInputPorts = CollectionUtil.nullToEmpty((Set)remoteProcessGroup.getInputPorts());
            Set rpgOutputPorts = CollectionUtil.nullToEmpty((Set)remoteProcessGroup.getOutputPorts());
            rpgIdToTargetIdMap.putAll(Stream.concat(rpgInputPorts.stream(), rpgOutputPorts.stream()).collect(Collectors.toMap(VersionedComponent::getIdentifier, VersionedRemoteGroupPort::getTargetId)));
            VersionedProcessGroupEnricher.addConnectables(connectableNameMap, rpgInputPorts, VersionedComponent::getIdentifier, VersionedComponent::getIdentifier);
            VersionedProcessGroupEnricher.addConnectables(connectableNameMap, rpgOutputPorts, VersionedComponent::getIdentifier, VersionedComponent::getIdentifier);
        }
        VersionedProcessGroupEnricher.addConnectables(connectableNameMap, VersionedProcessGroupEnricher.getAll(allVersionedProcessGroups, VersionedProcessGroup::getInputPorts).collect(Collectors.toList()), VersionedComponent::getIdentifier, VersionedComponent::getName);
        VersionedProcessGroupEnricher.addConnectables(connectableNameMap, VersionedProcessGroupEnricher.getAll(allVersionedProcessGroups, VersionedProcessGroup::getOutputPorts).collect(Collectors.toList()), VersionedComponent::getIdentifier, VersionedComponent::getName);
        Set connections = VersionedProcessGroupEnricher.getAll(allVersionedProcessGroups, VersionedProcessGroup::getConnections).collect(Collectors.toSet());
        for (VersionedConnection connection : connections) {
            VersionedProcessGroupEnricher.setName(connectableNameMap, connection.getSource(), rpgIdToTargetIdMap);
            VersionedProcessGroupEnricher.setName(connectableNameMap, connection.getDestination(), rpgIdToTargetIdMap);
        }
        connections.stream().flatMap(connectionDTO -> Stream.of(connectionDTO.getSource(), connectionDTO.getDestination())).filter(connectable -> connectable.getType() == ConnectableComponentType.REMOTE_OUTPUT_PORT || connectable.getType() == ConnectableComponentType.REMOTE_INPUT_PORT).forEach(connectable -> connectable.setId(Optional.ofNullable(rpgIdToTargetIdMap.get(connectable.getId())).orElse(connectable.getId())));
        for (VersionedConnection connection : connections) {
            if (!StringUtil.isNullOrEmpty((String)connection.getName())) continue;
            StringBuilder name = new StringBuilder();
            ConnectableComponent connectionSource = connection.getSource();
            name.append(VersionedProcessGroupEnricher.determineValueForConnectable(connectionSource, rpgIdToTargetIdMap));
            name.append("/");
            if (connection.getSelectedRelationships() != null && connection.getSelectedRelationships().size() > 0) {
                name.append((String)connection.getSelectedRelationships().iterator().next());
            }
            name.append("/");
            ConnectableComponent connectionDestination = connection.getDestination();
            name.append(VersionedProcessGroupEnricher.determineValueForConnectable(connectionDestination, rpgIdToTargetIdMap));
            connection.setName(name.toString());
        }
        CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getProcessGroups()).stream().forEach(pg -> this.enrich((VersionedProcessGroup)pg));
    }

    private static String determineValueForConnectable(ConnectableComponent connectable, Map<String, String> idOverrideMap) {
        String connectionName = "";
        if (connectable != null && StringUtils.isBlank((CharSequence)(connectionName = connectable.getName()))) {
            connectionName = idOverrideMap.containsKey(connectable.getId()) ? idOverrideMap.get(connectable.getId()) : connectable.getId();
        }
        return connectionName;
    }

    private static <T> Stream<T> getAll(List<VersionedProcessGroup> allVersionedProcessGroups, Function<VersionedProcessGroup, Collection<T>> accessor) {
        return allVersionedProcessGroups.stream().flatMap(f -> ((Collection)accessor.apply((VersionedProcessGroup)f)).stream()).filter(Objects::nonNull);
    }

    private static List<VersionedProcessGroup> getAllVersionedProcessGroups(VersionedProcessGroup versionedProcessGroup) {
        ArrayList<VersionedProcessGroup> result = new ArrayList<VersionedProcessGroup>();
        VersionedProcessGroupEnricher.getAllVersionedProcessGroups(versionedProcessGroup, result);
        return result;
    }

    private static void getAllVersionedProcessGroups(VersionedProcessGroup versionedProcessGroup, List<VersionedProcessGroup> result) {
        result.add(versionedProcessGroup);
        CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getProcessGroups()).stream().forEach(f -> VersionedProcessGroupEnricher.getAllVersionedProcessGroups(f, result));
    }

    private static void setName(Map<String, String> connectableNameMap, ConnectableComponent connectable, Map<String, String> nameOverrides) {
        String name;
        if (connectable != null && (name = connectableNameMap.get(connectable.getId())) != null) {
            connectable.setName(Optional.ofNullable(nameOverrides.get(connectable.getId())).orElse(name));
        }
    }

    private static <T> void addConnectables(Map<String, String> connectableNameMap, Collection<T> hasIdAndNames, Function<T, String> idGetter, Function<T, String> nameGetter) {
        if (hasIdAndNames != null) {
            for (T hasIdAndName : hasIdAndNames) {
                String id = idGetter.apply(hasIdAndName);
                String name = nameGetter.apply(hasIdAndName);
                if (StringUtil.isNullOrEmpty((String)name)) continue;
                connectableNameMap.put(id, name);
            }
        }
    }
}

