/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.flowfile.FlowFilePrioritizer;

public class QueuePrioritizer
implements Comparator<FlowFileRecord>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient List<FlowFilePrioritizer> prioritizers = new ArrayList<FlowFilePrioritizer>();

    public QueuePrioritizer(List<FlowFilePrioritizer> priorities) {
        if (null != priorities) {
            this.prioritizers.addAll(priorities);
        }
    }

    @Override
    public int compare(FlowFileRecord f1, FlowFileRecord f2) {
        int returnVal = 0;
        boolean f1Penalized = f1.isPenalized();
        boolean f2Penalized = f2.isPenalized();
        if (f1Penalized && !f2Penalized) {
            return 1;
        }
        if (!f1Penalized && f2Penalized) {
            return -1;
        }
        if (f1Penalized && f2Penalized) {
            if (f1.getPenaltyExpirationMillis() < f2.getPenaltyExpirationMillis()) {
                return -1;
            }
            if (f1.getPenaltyExpirationMillis() > f2.getPenaltyExpirationMillis()) {
                return 1;
            }
        }
        if (!this.prioritizers.isEmpty()) {
            for (FlowFilePrioritizer prioritizer : this.prioritizers) {
                returnVal = prioritizer.compare((Object)f1, (Object)f2);
                if (returnVal == 0) continue;
                return returnVal;
            }
        }
        ContentClaim claim1 = f1.getContentClaim();
        ContentClaim claim2 = f2.getContentClaim();
        if (claim1 == null && claim2 != null) {
            return -1;
        }
        if (claim1 != null && claim2 == null) {
            return 1;
        }
        if (claim1 != null && claim2 != null) {
            int claimComparison = claim1.compareTo((Object)claim2);
            if (claimComparison != 0) {
                return claimComparison;
            }
            int claimOffsetComparison = Long.compare(f1.getContentClaimOffset(), f2.getContentClaimOffset());
            if (claimOffsetComparison != 0) {
                return claimOffsetComparison;
            }
        }
        return Long.compare(f1.getId(), f2.getId());
    }
}

