/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class MemoryManager {
    private final int blockSize;
    private final BlockingQueue<byte[]> queue;

    public MemoryManager(long totalSize, int blockSize) {
        this.blockSize = blockSize;
        int numBlocks = (int)(totalSize / (long)blockSize);
        this.queue = new LinkedBlockingQueue<byte[]>(numBlocks);
        for (int i = 0; i < numBlocks; ++i) {
            this.queue.offer(new byte[blockSize]);
        }
    }

    byte[] checkOut() {
        return (byte[])this.queue.poll();
    }

    void checkIn(byte[] buffer) {
        this.queue.offer(buffer);
    }

    void checkIn(Collection<byte[]> buffers) {
        this.queue.addAll(buffers);
    }

    int getBlockSize() {
        return this.blockSize;
    }
}

