/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.h2.database.migration;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.nifi.h2.database.migration.DatabaseVersion;

class DatabaseVersionReader {
    private static final int KEY_VALUE_SEPARATOR = 44;
    private static final byte[] FORMAT_PREFIX = "format:".getBytes(StandardCharsets.UTF_8);
    private static final int FORMAT_PREFIX_LENGTH = FORMAT_PREFIX.length;
    private static final int DECIMAL_RADIX = 10;
    private static final int END_OF_FILE = -1;

    DatabaseVersionReader() {
    }

    static DatabaseVersion readDatabaseVersion(Path filePath) {
        DatabaseVersion databaseVersion;
        if (Files.isReadable(filePath)) {
            try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);){
                databaseVersion = DatabaseVersionReader.findDatabaseVersion(inputStream);
            }
            catch (Exception e) {
                databaseVersion = DatabaseVersion.UNKNOWN;
            }
        } else {
            databaseVersion = DatabaseVersion.UNKNOWN;
        }
        return databaseVersion;
    }

    private static DatabaseVersion findDatabaseVersion(InputStream inputStream) throws IOException {
        DatabaseVersion databaseVersion = DatabaseVersion.UNKNOWN;
        ByteBuffer formatPrefixBuffer = ByteBuffer.allocate(FORMAT_PREFIX_LENGTH);
        boolean formatStartFound = false;
        int read = 0;
        while (read != -1) {
            read = inputStream.read();
            if (formatStartFound) {
                if (formatPrefixBuffer.hasRemaining()) {
                    formatPrefixBuffer.put((byte)read);
                    continue;
                }
                byte[] formatPrefixBytes = new byte[FORMAT_PREFIX_LENGTH];
                formatPrefixBuffer.flip();
                formatPrefixBuffer.get(formatPrefixBytes);
                if (Arrays.equals(FORMAT_PREFIX, formatPrefixBytes)) {
                    int formatVersion = Character.digit(read, 10);
                    databaseVersion = DatabaseVersionReader.getDatabaseVersion(formatVersion);
                    break;
                }
                formatStartFound = false;
                continue;
            }
            if (44 != read) continue;
            formatPrefixBuffer.clear();
            formatStartFound = true;
        }
        return databaseVersion;
    }

    private static DatabaseVersion getDatabaseVersion(int formatVersion) {
        DatabaseVersion databaseVersion = DatabaseVersion.UNKNOWN;
        for (DatabaseVersion currentDatabaseVersion : DatabaseVersion.values()) {
            if (currentDatabaseVersion.getFormatVersion() != formatVersion) continue;
            databaseVersion = currentDatabaseVersion;
            break;
        }
        return databaseVersion;
    }
}

