/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.h2.database.migration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.nifi.h2.database.migration.DatabaseExporter;
import org.apache.nifi.h2.database.migration.DatabaseStatementRunner;
import org.apache.nifi.h2.database.migration.DatabaseVersion;
import org.apache.nifi.h2.database.migration.DatabaseVersionReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DatabaseUpdater {
    public static final String H2_URL_PREFIX = "jdbc:h2:";
    private static final DatabaseVersion LATEST_VERSION = DatabaseVersion.VERSION_2_2;
    private static final String FILE_PATH_FORMAT = "%s.mv.db";
    private static final String RUNSCRIPT_FORMAT = "RUNSCRIPT FROM '%s'";
    private static final Logger logger = LoggerFactory.getLogger(H2DatabaseUpdater.class);

    public static void checkAndPerformMigration(String dbPathNoExtension, String url, String user, String pass) throws Exception {
        Path databaseFilePath = Paths.get(String.format(FILE_PATH_FORMAT, dbPathNoExtension), new String[0]);
        DatabaseVersion databaseVersion = DatabaseVersionReader.readDatabaseVersion(databaseFilePath);
        if (LATEST_VERSION == databaseVersion) {
            logger.debug("H2 DB migration not required from Driver {} for [{}]", (Object)databaseVersion.getVersion(), (Object)databaseFilePath);
        } else {
            logger.info("H2 DB migration required to Driver {} from Driver {} for [{}]", new Object[]{LATEST_VERSION.getVersion(), databaseVersion.getVersion(), databaseFilePath});
            Path exportScriptPath = DatabaseExporter.runExportBackup(databaseVersion, user, pass, dbPathNoExtension);
            String command = String.format(RUNSCRIPT_FORMAT, exportScriptPath);
            DatabaseStatementRunner.run(LATEST_VERSION, url, user, pass, command);
            logger.info("H2 DB migration completed to Driver {} from Driver {} for [{}]", new Object[]{LATEST_VERSION.getVersion(), databaseVersion.getVersion(), databaseFilePath});
            try {
                Files.delete(exportScriptPath);
            }
            catch (IOException e) {
                logger.warn("H2 DB {} for [{}] delete export script failed [{}]", new Object[]{databaseVersion.getVersion(), databaseFilePath, exportScriptPath, e});
            }
        }
    }
}

