/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.controller.Counter;
import org.apache.nifi.controller.StandardCounter;
import org.apache.nifi.controller.repository.CounterRepository;

public class StandardCounterRepository
implements CounterRepository {
    private final ConcurrentMap<String, ConcurrentMap<String, Counter>> processorCounters = new ConcurrentHashMap<String, ConcurrentMap<String, Counter>>();

    public Counter getCounter(String counterContext, String name) {
        return StandardCounter.unmodifiableCounter(this.getModifiableCounter(counterContext, name));
    }

    private String getIdentifier(String counterContext, String name) {
        String contextId = UUID.nameUUIDFromBytes(counterContext.getBytes(StandardCharsets.UTF_8)).toString();
        String nameId = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8)).toString();
        String contextAndName = contextId + "-" + nameId;
        return UUID.nameUUIDFromBytes(contextAndName.getBytes(StandardCharsets.UTF_8)).toString();
    }

    private Counter getModifiableCounter(String counterContext, String name) {
        Counter oldCounter;
        Counter counter;
        ConcurrentMap oldProcessorCounters;
        ConcurrentMap<String, Counter> counters = (ConcurrentHashMap)this.processorCounters.get(counterContext);
        if (counters == null && (oldProcessorCounters = (ConcurrentMap)this.processorCounters.putIfAbsent(counterContext, counters = new ConcurrentHashMap())) != null) {
            counters = oldProcessorCounters;
        }
        if ((counter = (Counter)counters.get(name)) == null && (oldCounter = counters.putIfAbsent(name, counter = new StandardCounter(this.getIdentifier(counterContext, name), counterContext, name))) != null) {
            counter = oldCounter;
        }
        return counter;
    }

    public void adjustCounter(String counterContext, String name, long delta) {
        this.getModifiableCounter(counterContext, name).adjust(delta);
    }

    public List<Counter> getCounters(String counterContext) {
        ArrayList<Counter> counters = new ArrayList<Counter>();
        Map map = (Map)this.processorCounters.get(counterContext);
        if (map == null) {
            return counters;
        }
        for (Counter counter : map.values()) {
            counters.add(StandardCounter.unmodifiableCounter(counter));
        }
        return counters;
    }

    public List<Counter> getCounters() {
        ArrayList<Counter> counters = new ArrayList<Counter>();
        for (Map map : this.processorCounters.values()) {
            for (Counter counter : map.values()) {
                counters.add(StandardCounter.unmodifiableCounter(counter));
            }
        }
        return counters;
    }

    public Counter resetCounter(String identifier) {
        for (ConcurrentMap counters : this.processorCounters.values()) {
            for (Counter counter : counters.values()) {
                if (!counter.getIdentifier().equals(identifier)) continue;
                counter.reset();
                return counter;
            }
        }
        return null;
    }
}

