/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceReference;

public class StandardControllerServiceReference
implements ControllerServiceReference {
    private final ControllerServiceNode referenced;
    private final Set<ComponentNode> components;

    public StandardControllerServiceReference(ControllerServiceNode referencedService, Set<ComponentNode> referencingComponents) {
        this.referenced = referencedService;
        this.components = new HashSet<ComponentNode>(referencingComponents);
    }

    public ControllerServiceNode getReferencedComponent() {
        return this.referenced;
    }

    public Set<ComponentNode> getReferencingComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    private boolean isRunning(ComponentNode component) {
        if (component instanceof ReportingTaskNode) {
            return ((ReportingTaskNode)component).isRunning();
        }
        if (component instanceof ProcessorNode) {
            return ((ProcessorNode)component).isRunning();
        }
        if (component instanceof ControllerServiceNode) {
            return ((ControllerServiceNode)component).isActive();
        }
        return false;
    }

    public Set<ComponentNode> getActiveReferences() {
        HashSet<ComponentNode> activeReferences = new HashSet<ComponentNode>();
        for (ComponentNode component : this.components) {
            if (!this.isRunning(component)) continue;
            activeReferences.add(component);
        }
        for (ComponentNode component : this.findRecursiveReferences(ComponentNode.class)) {
            if (!this.isRunning(component)) continue;
            activeReferences.add(component);
        }
        return activeReferences;
    }

    public <T> List<T> findRecursiveReferences(Class<T> componentType) {
        return this.findRecursiveReferences(this.referenced, componentType);
    }

    private <T> List<T> findRecursiveReferences(ControllerServiceNode referencedNode, Class<T> componentType) {
        return this.findRecursiveReferences(referencedNode, componentType, new HashSet<ControllerServiceNode>());
    }

    private <T> List<T> findRecursiveReferences(ControllerServiceNode referencedNode, Class<T> componentType, Set<ControllerServiceNode> servicesVisited) {
        ArrayList<T> references = new ArrayList<T>();
        for (ComponentNode referencingComponent : referencedNode.getReferences().getReferencingComponents()) {
            ControllerServiceNode referencingNode;
            boolean added;
            if (componentType.isAssignableFrom(referencingComponent.getClass())) {
                references.add(componentType.cast(referencingComponent));
            }
            if (!(referencingComponent instanceof ControllerServiceNode) || !(added = servicesVisited.add(referencingNode = (ControllerServiceNode)referencingComponent))) continue;
            List<T> recursive = this.findRecursiveReferences(referencingNode, componentType, servicesVisited);
            references.removeAll(recursive);
            references.addAll(recursive);
        }
        return references;
    }
}

