/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.registry.VariableDescriptor;

public interface VariableRegistry {
    public static final VariableRegistry EMPTY_REGISTRY = () -> Collections.emptyMap();
    public static final VariableRegistry ENVIRONMENT_SYSTEM_REGISTRY = new VariableRegistry(){
        final Map<VariableDescriptor, String> map = new HashMap<VariableDescriptor, String>();
        {
            System.getenv().entrySet().stream().forEach(entry -> {
                VariableDescriptor desc = new VariableDescriptor.Builder((String)entry.getKey()).description("Env Var").sensitive(false).build();
                this.map.put(desc, (String)entry.getValue());
            });
            System.getProperties().entrySet().stream().forEach(entry -> {
                VariableDescriptor desc = new VariableDescriptor.Builder(entry.getKey().toString()).description("System Property").sensitive(false).build();
                this.map.put(desc, entry.getValue().toString());
            });
        }

        @Override
        public Map<VariableDescriptor, String> getVariableMap() {
            return Collections.unmodifiableMap(this.map);
        }
    };

    public Map<VariableDescriptor, String> getVariableMap();

    default public VariableDescriptor getVariableKey(String name) {
        if (name == null) {
            return null;
        }
        VariableDescriptor spec = new VariableDescriptor(name);
        for (Map.Entry<VariableDescriptor, String> entry : this.getVariableMap().entrySet()) {
            if (!entry.getKey().equals(spec)) continue;
            return entry.getKey();
        }
        return null;
    }

    default public String getVariableValue(String name) {
        if (name == null) {
            return null;
        }
        return this.getVariableMap().get(new VariableDescriptor(name));
    }

    default public String getVariableValue(VariableDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getVariableMap().get(descriptor);
    }
}

