/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.Objects;
import org.apache.nifi.properties.AbstractHashiCorpVaultSensitivePropertyProvider;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProtectionException;

public class HashiCorpVaultKeyValueSensitivePropertyProvider
extends AbstractHashiCorpVaultSensitivePropertyProvider {
    private static final String KEY_VALUE_PATH = "vault.kv.path";
    private static final String IDENTIFIER_KEY_FORMAT = "hashicorp/vault/kv/%s";

    HashiCorpVaultKeyValueSensitivePropertyProvider(BootstrapProperties bootstrapProperties) {
        super(bootstrapProperties);
    }

    @Override
    protected String getSecretsEnginePath(BootstrapProperties vaultBootstrapProperties) {
        if (vaultBootstrapProperties == null) {
            return null;
        }
        return vaultBootstrapProperties.getProperty(KEY_VALUE_PATH);
    }

    public String getIdentifierKey() {
        return String.format(IDENTIFIER_KEY_FORMAT, this.getPath());
    }

    public String protect(String unprotectedValue, ProtectedPropertyContext context) throws SensitivePropertyProtectionException {
        this.requireNotBlank(unprotectedValue);
        Objects.requireNonNull(context, "Context is required to protect a value");
        this.getVaultCommunicationService().writeKeyValueSecret(this.getPath(), context.getContextKey(), unprotectedValue);
        return String.format("%s/%s", this.getPath(), context.getContextKey());
    }

    public String unprotect(String protectedValue, ProtectedPropertyContext context) throws SensitivePropertyProtectionException {
        Objects.requireNonNull(context, "Context is required to unprotect a value");
        return (String)this.getVaultCommunicationService().readKeyValueSecret(this.getPath(), context.getContextKey()).orElseThrow(() -> new SensitivePropertyProtectionException(String.format("Secret [%s] not found in Vault Key/Value engine at [%s]", context.getContextKey(), this.getPath())));
    }
}

