/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamProviderClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;

public class DeleteParamProvider
extends AbstractNiFiCommand<StringResult> {
    public DeleteParamProvider() {
        super("delete-param-provider", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Deletes a parameter provider.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_PROVIDER_ID.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramProviderId = this.getRequiredArg(properties, CommandOption.PARAM_PROVIDER_ID);
        ParamProviderClient paramProviderClient = client.getParamProviderClient();
        ParameterProviderEntity existingParamContext = paramProviderClient.getParamProvider(paramProviderId);
        String version = String.valueOf(existingParamContext.getRevision().getVersion());
        paramProviderClient.deleteParamProvider(paramProviderId, version);
        return new StringResult(paramProviderId, this.isInteractive());
    }
}

