/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.templates;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.persistence.TemplateDeserializer;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.entity.TemplateEntity;

public class UploadTemplate
extends AbstractNiFiCommand<StringResult> {
    public UploadTemplate() {
        super("upload-template", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Uploads a local template file.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String processGroupId = this.getRequiredArg(properties, CommandOption.PG_ID);
        String inputFile = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        FileInputStream file = new FileInputStream(Paths.get(inputFile, new String[0]).toAbsolutePath().toFile());
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        TemplateEntity createdEntity = pgClient.uploadTemplate(processGroupId, TemplateDeserializer.deserialize((InputStream)file));
        return new StringResult(String.valueOf(createdEntity.getTemplate().getId()), this.getContext().isInteractive());
    }
}

