/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;

public class ParamProviderResult
extends AbstractWritableResult<ParameterProviderEntity> {
    private final ParameterProviderEntity parameterProvider;

    public ParamProviderResult(ResultType resultType, ParameterProviderEntity parameterProvider) {
        super(resultType);
        this.parameterProvider = parameterProvider;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        ParameterProviderDTO parameterProviderDTO = this.parameterProvider.getComponent();
        Collection fetchedParameterNameGroups = parameterProviderDTO.getParameterGroupConfigurations();
        ArrayList sortedParameterNameGroups = fetchedParameterNameGroups == null ? Collections.emptyList() : new ArrayList(parameterProviderDTO.getParameterGroupConfigurations());
        Collections.sort(sortedParameterNameGroups);
        Table propertiesTable = new Table.Builder().column("Property Name", 20, 60, false).column("Property Value", 20, 80, false).build();
        if (parameterProviderDTO.getProperties() != null && !parameterProviderDTO.getProperties().isEmpty()) {
            parameterProviderDTO.getProperties().forEach((name, value) -> propertiesTable.addRow((String)name, (String)value));
        }
        Table fetchedParametersTable = new Table.Builder().column("Parameter Group", 20, 60, false).column("Parameter Context Name", 20, 60, false).column("Fetched Parameter Name", 20, 60, false).build();
        if (!sortedParameterNameGroups.isEmpty()) {
            sortedParameterNameGroups.forEach(group -> group.getParameterSensitivities().keySet().stream().sorted().forEach(param -> fetchedParametersTable.addRow(group.getGroupName(), group.getParameterContextName(), (String)param)));
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        if (!propertiesTable.getRows().isEmpty()) {
            tableWriter.write(propertiesTable, output);
        }
        if (!fetchedParametersTable.getRows().isEmpty()) {
            tableWriter.write(fetchedParametersTable, output);
        }
    }

    @Override
    public ParameterProviderEntity getResult() {
        return this.parameterProvider;
    }
}

