/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.entity.TemplateEntity;
import org.apache.nifi.web.api.entity.TemplatesEntity;

public class TemplatesResult
extends AbstractWritableResult<TemplatesEntity> {
    private final TemplatesEntity templatesEntity;

    public TemplatesResult(ResultType resultType, TemplatesEntity templatesEntity) {
        super(resultType);
        this.templatesEntity = templatesEntity;
        Validate.notNull((Object)this.templatesEntity);
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Set templateEntities = this.templatesEntity.getTemplates();
        if (templateEntities == null) {
            return;
        }
        List templateDTOS = templateEntities.stream().map(TemplateEntity::getTemplate).sorted(Comparator.comparing(TemplateDTO::getGroupId)).collect(Collectors.toList());
        Table table = new Table.Builder().column("#", 1, 4, false).column("Name", 5, 40, false).column("ID", 36, 36, false).column("Group ID", 36, 36, false).build();
        for (int i = 0; i < templateDTOS.size(); ++i) {
            TemplateDTO templateDTO = (TemplateDTO)templateDTOS.get(i);
            table.addRow(String.valueOf(i + 1), templateDTO.getName(), templateDTO.getId(), templateDTO.getGroupId());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public TemplatesEntity getResult() {
        return this.templatesEntity;
    }
}

