/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.zkmigrator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class DataStatAclNode {
    private final String path;
    private final byte[] data;
    private final Stat stat;
    private final List<ACL> acls;
    private final long ephemeralOwner;

    DataStatAclNode(String path, byte[] data, Stat stat, List<ACL> acls, long ephemeralOwner) {
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path can not be null");
        this.data = data;
        this.stat = (Stat)Preconditions.checkNotNull((Object)stat, (Object)"stat can not be null");
        this.acls = acls == null ? ImmutableList.of() : ImmutableList.copyOf(acls);
        this.ephemeralOwner = ephemeralOwner;
    }

    String getPath() {
        return this.path;
    }

    byte[] getData() {
        return this.data;
    }

    Stat getStat() {
        return this.stat;
    }

    List<ACL> getAcls() {
        return this.acls;
    }

    long getEphemeralOwner() {
        return this.ephemeralOwner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStatAclNode that = (DataStatAclNode)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("acls", this.acls).add("ephemeralOwner", this.ephemeralOwner).toString();
    }
}

