/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.zkmigrator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class ZooKeeperNode {
    private final String path;
    private final List<ZooKeeperNode> children;

    public ZooKeeperNode(String path, List<ZooKeeperNode> children) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"path can not be null or empty");
        this.path = path;
        this.children = children == null ? ImmutableList.of() : ImmutableList.copyOf(children);
    }

    public String getPath() {
        return this.path;
    }

    public List<ZooKeeperNode> getChildren() {
        return this.children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZooKeeperNode node = (ZooKeeperNode)o;
        return Objects.equals(this.path, node.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("children", this.children).toString();
    }
}

