/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Scanner;
import java.util.Set;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.gc.ComputeUtilizationFromScratchJob;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.gc.GcJob;
import jetbrains.exodus.gc.UtilizationProfile;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.log.AbstractBlockListener;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.tree.ExpiredLoggableCollection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\u0016J\r\u0010\u001a\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001bJ\r\u0010\u001c\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$J\u0015\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b'J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0)2\u0006\u0010*\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b+J\u0006\u0010,\u001a\u00020\u0016J\u000e\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/J\u0015\u00100\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b3J\u000e\u00104\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$J\u001b\u00105\u001a\u00020\u00162\f\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a2\u0006\u0002\b7J\r\u00108\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J\u0006\u0010;\u001a\u000209R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Ljetbrains/exodus/gc/UtilizationProfile;", "", "env", "Ljetbrains/exodus/env/EnvironmentImpl;", "gc", "Ljetbrains/exodus/gc/GarbageCollector;", "(Ljetbrains/exodus/env/EnvironmentImpl;Ljetbrains/exodus/gc/GarbageCollector;)V", "fileSize", "", "filesUtilization", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;", "Ljetbrains/exodus/gc/UtilizationProfile$MutableLong;", "isDirty", "", "()Z", "setDirty", "(Z)V", "log", "Ljetbrains/exodus/log/Log;", "totalBytes", "totalFreeBytes", "clear", "", "clear$xodus_environment", "clearUtilization", "computeUtilizationFromScratch", "estimateTotalBytes", "estimateTotalBytes$xodus_environment", "estimateTotalBytesAndWakeGcIfNecessary", "estimateTotalBytesAndWakeGcIfNecessary$xodus_environment", "fetchExpiredLoggables", "loggables", "Ljetbrains/exodus/tree/ExpiredLoggableCollection;", "fetchExpiredLoggables$xodus_environment", "forceSave", "txn", "Ljetbrains/exodus/env/Transaction;", "getFileFreeBytes", "fileAddress", "getFileFreeBytes$xodus_environment", "getFilesSortedByUtilization", "", "highFile", "getFilesSortedByUtilization$xodus_environment", "load", "loadUtilizationFromFile", "path", "", "removeFile", "removeFile$xodus_environment", "resetFile", "resetFile$xodus_environment", "save", "setUtilization", "usedSpace", "setUtilization$xodus_environment", "totalFreeSpacePercent", "", "totalFreeSpacePercent$xodus_environment", "totalUtilizationPercent", "MutableLong", "xodus-environment"})
public final class UtilizationProfile {
    @NotNull
    private final EnvironmentImpl env;
    @NotNull
    private final GarbageCollector gc;
    @NotNull
    private final Log log;
    private final long fileSize;
    @NotNull
    private final LongHashMap<MutableLong> filesUtilization;
    private long totalBytes;
    private long totalFreeBytes;
    private volatile boolean isDirty;

    public UtilizationProfile(@NotNull EnvironmentImpl env, @NotNull GarbageCollector gc) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        this.env = env;
        this.gc = gc;
        Log log = this.env.getLog();
        Intrinsics.checkNotNullExpressionValue((Object)log, (String)"env.log");
        this.log = log;
        this.fileSize = this.log.getFileLengthBound();
        this.filesUtilization = new LongHashMap(0, 0.0f, 3, null);
        this.log.addBlockListener(new AbstractBlockListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void blockCreated(@NotNull Block block, @NotNull DataReader reader, @NotNull DataWriter writer) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                LongHashMap $this$synchronized$iv = filesUtilization;
                boolean $i$f$synchronized = false;
                synchronized ($this$synchronized$iv) {
                    boolean bl = false;
                    LongHashMap $this$blockCreated_u24lambda_u2d0 = $this$synchronized$iv;
                    boolean bl2 = false;
                    ((Map)$this$blockCreated_u24lambda_u2d0).put(block.getAddress(), new MutableLong(0L));
                    Unit unit = Unit.INSTANCE;
                }
                this.estimateTotalBytes$xodus_environment();
            }
        });
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear$xodus_environment() {
        Unit unit;
        LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<MutableLong> $this$clear_u24lambda_u2d0 = $this$synchronized$iv;
            boolean bl2 = false;
            $this$clear_u24lambda_u2d0.clear();
            Unit unit2 = Unit.INSTANCE;
        }
        Unit $this$clear_u24lambda_u2d1 = unit = Unit.INSTANCE;
        boolean bl = false;
        this.estimateTotalBytes$xodus_environment();
    }

    public final void load() {
        EnvironmentConfig environmentConfig = this.env.getEnvironmentConfig();
        Intrinsics.checkNotNullExpressionValue((Object)environmentConfig, (String)"env.environmentConfig");
        EnvironmentConfig ec = environmentConfig;
        if (ec.getGcUtilizationFromScratch()) {
            this.computeUtilizationFromScratch();
        } else {
            String storedUtilization = ec.getGcUtilizationFromFile();
            Intrinsics.checkNotNullExpressionValue((Object)storedUtilization, (String)"storedUtilization");
            if (!(((CharSequence)storedUtilization).length() == 0)) {
                this.loadUtilizationFromFile(storedUtilization);
            } else {
                this.env.executeInReadonlyTransaction(arg_0 -> UtilizationProfile.load$lambda-6(this, arg_0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        if (this.isDirty) {
            Object object = this.env.openStore("exodus.gc.up", StoreConfig.WITHOUT_DUPLICATES, txn);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.openStore(GarbageCol\u2026.WITHOUT_DUPLICATES, txn)");
            StoreImpl store = object;
            object = (Closeable)store.openCursor(txn);
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)object;
                boolean bl = false;
                while (cursor.getNext()) {
                    boolean bl2;
                    long fileAddress = LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey());
                    LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
                    boolean $i$f$synchronized = false;
                    synchronized ($this$synchronized$iv) {
                        boolean bl3 = false;
                        LongHashMap<MutableLong> $this$save_u24lambda_u2d8_u24lambda_u2d7 = $this$synchronized$iv;
                        boolean bl4 = false;
                        bl2 = !$this$save_u24lambda_u2d8_u24lambda_u2d7.containsKey((Object)fileAddress);
                    }
                    if (!bl2) continue;
                    cursor.deleteCurrent();
                }
                cursor = Unit.INSTANCE;
            }
            catch (Throwable cursor) {
                throwable = cursor;
                throw cursor;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
            boolean $i$f$synchronized = false;
            synchronized ($this$synchronized$iv) {
                boolean bl = false;
                LongHashMap<MutableLong> $this$save_u24lambda_u2d10 = $this$synchronized$iv;
                boolean bl5 = false;
                Set set = $this$save_u24lambda_u2d10.entrySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entries");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl6 = false;
                    Object k = entry.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                    store.put(txn, (ByteIterable)LongBinding.longToCompressedEntry((long)((Number)k).longValue()), CompressedUnsignedLongByteIterable.getIterable(((MutableLong)entry.getValue()).getValue()));
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void forceSave(@NotNull Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        this.isDirty = true;
        this.save(txn);
    }

    public final int totalFreeSpacePercent$xodus_environment() {
        long totalBytes = this.totalBytes;
        return (int)(totalBytes == 0L ? 0L : this.totalFreeBytes * 100L / totalBytes);
    }

    public final int totalUtilizationPercent() {
        return 100 - this.totalFreeSpacePercent$xodus_environment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getFileFreeBytes$xodus_environment(long fileAddress) {
        long l;
        LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            long l2;
            boolean bl = false;
            LongHashMap<MutableLong> $this$getFileFreeBytes_u24lambda_u2d11 = $this$synchronized$iv;
            boolean bl2 = false;
            MutableLong mutableLong = (MutableLong)$this$getFileFreeBytes_u24lambda_u2d11.get((Object)fileAddress);
            l = mutableLong == null ? Long.MAX_VALUE : (l2 = mutableLong.getValue());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fetchExpiredLoggables$xodus_environment(@NotNull ExpiredLoggableCollection loggables) {
        Intrinsics.checkNotNullParameter((Object)loggables, (String)"loggables");
        Ref.LongRef prevFileAddress = new Ref.LongRef();
        prevFileAddress.element = -1L;
        Ref.ObjectRef prevFreeBytes = new Ref.ObjectRef();
        PackedLongHashSet set = new PackedLongHashSet(null, 0.0f, 3, null);
        LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<MutableLong> $this$fetchExpiredLoggables_u24lambda_u2d12 = $this$synchronized$iv;
            boolean bl2 = false;
            for (ExpiredLoggableCollection l = loggables; l != null; l = l.forEach((Function2<? super Long, ? super Integer, Unit>)((Function2)new Function2<Long, Integer, Unit>(set, this, prevFileAddress, (Ref.ObjectRef<MutableLong>)prevFreeBytes, $this$fetchExpiredLoggables_u24lambda_u2d12){
                final /* synthetic */ PackedLongHashSet $set;
                final /* synthetic */ UtilizationProfile this$0;
                final /* synthetic */ Ref.LongRef $prevFileAddress;
                final /* synthetic */ Ref.ObjectRef<MutableLong> $prevFreeBytes;
                final /* synthetic */ LongHashMap<MutableLong> $this_synchronized;
                {
                    this.$set = $set;
                    this.this$0 = $receiver;
                    this.$prevFileAddress = $prevFileAddress;
                    this.$prevFreeBytes = $prevFreeBytes;
                    this.$this_synchronized = $receiver2;
                    super(2);
                }

                public final void invoke(long address, int length) {
                    if (this.$set.add(address)) {
                        MutableLong mutableLong;
                        MutableLong mutableLong2;
                        long fileAddress = UtilizationProfile.access$getLog$p(this.this$0).getFileAddress(address);
                        MutableLong mutableLong3 = mutableLong2 = this.$prevFileAddress.element == fileAddress ? (MutableLong)this.$prevFreeBytes.element : (MutableLong)this.$this_synchronized.get((Object)fileAddress);
                        if (mutableLong2 == null) {
                            MutableLong mutableLong4 = new MutableLong(0L);
                            LongHashMap<MutableLong> longHashMap = this.$this_synchronized;
                            MutableLong it = mutableLong4;
                            boolean bl = false;
                            Map map = (Map)longHashMap;
                            Long l = fileAddress;
                            map.put(l, it);
                            mutableLong = mutableLong4;
                        } else {
                            mutableLong = mutableLong2;
                        }
                        MutableLong freeBytes = mutableLong;
                        freeBytes.setValue(freeBytes.getValue() + (long)length);
                        this.$prevFreeBytes.element = freeBytes;
                        this.$prevFileAddress.element = fileAddress;
                    }
                }
            }))) {
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFile$xodus_environment(long fileAddress) {
        LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<MutableLong> $this$removeFile_u24lambda_u2d13 = $this$synchronized$iv;
            boolean bl2 = false;
            $this$removeFile_u24lambda_u2d13.remove((Object)fileAddress);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetFile$xodus_environment(long fileAddress) {
        LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<MutableLong> $this$resetFile_u24lambda_u2d14 = $this$synchronized$iv;
            boolean bl2 = false;
            MutableLong mutableLong = (MutableLong)$this$resetFile_u24lambda_u2d14.get((Object)fileAddress);
            if (mutableLong != null) {
                mutableLong.setValue(0L);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void estimateTotalBytes$xodus_environment() {
        long totalBytes;
        long l;
        long[] fileAddresses = this.log.getAllFileAddresses();
        int filesCount = fileAddresses.length;
        int minFileAge = this.gc.getMinFileAge$xodus_environment();
        LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            void $this$fold$iv;
            boolean bl = false;
            LongHashMap<MutableLong> $this$estimateTotalBytes_u24lambda_u2d16 = $this$synchronized$iv;
            boolean bl2 = false;
            Iterable iterable = (Iterable)RangesKt.until((int)minFileAge, (int)filesCount);
            long initial$iv = 0L;
            boolean $i$f$fold = false;
            long accumulator$iv = initial$iv;
            Iterator iterator = $this$fold$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                int element$iv;
                int n = element$iv = ((IntIterator)iterator).nextInt();
                long sum = accumulator$iv;
                boolean bl3 = false;
                MutableLong mutableLong = (MutableLong)$this$estimateTotalBytes_u24lambda_u2d16.get((Object)fileAddresses[i]);
                Long l2 = mutableLong == null ? null : Long.valueOf(mutableLong.getValue());
                accumulator$iv = sum + (l2 == null ? this.fileSize : l2);
            }
            l = accumulator$iv;
        }
        long totalFreeBytes = l;
        this.totalBytes = totalBytes = filesCount > minFileAge ? (long)(filesCount - minFileAge) * this.fileSize : 0L;
        this.totalFreeBytes = Math.min(totalFreeBytes, totalBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iterator<Long> getFilesSortedByUtilization$xodus_environment(long highFile) {
        long[] fileAddresses = this.log.getAllFileAddresses();
        long maxFreeBytes = this.fileSize * (long)this.gc.getMaximumFreeSpacePercent$xodus_environment() / 100L;
        PriorityQueue<Pair<Long, Long>> fragmentedFiles = new PriorityQueue<Pair<Long, Long>>(10, UtilizationProfile::getFilesSortedByUtilization$lambda-17);
        Ref.LongRef totalCleanableBytes = new Ref.LongRef();
        Ref.LongRef totalFreeBytes = new Ref.LongRef();
        LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<MutableLong> $this$getFilesSortedByUtilization_u24lambda_u2d19 = $this$synchronized$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)this.gc.getMinFileAge$xodus_environment(), (int)fileAddresses.length);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                long l;
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl3 = false;
                long file = fileAddresses[i];
                if (file >= highFile || this.gc.isFileCleaned$xodus_environment(file)) continue;
                totalCleanableBytes.element += this.fileSize;
                MutableLong freeBytes = (MutableLong)$this$getFilesSortedByUtilization_u24lambda_u2d19.get((Object)file);
                long l2 = totalFreeBytes.element;
                if (freeBytes == null) {
                    fragmentedFiles.add((Pair<Long, Long>)new Pair((Object)file, (Object)this.fileSize));
                    l = this.fileSize;
                } else {
                    long freeBytesValue = freeBytes.getValue();
                    if (freeBytesValue > maxFreeBytes) {
                        fragmentedFiles.add((Pair<Long, Long>)new Pair((Object)file, (Object)freeBytesValue));
                    }
                    l = freeBytesValue;
                }
                totalFreeBytes.element = l2 + l;
            }
            Unit unit = Unit.INSTANCE;
        }
        return new Iterator<Long>(fragmentedFiles, totalFreeBytes, totalCleanableBytes, this){
            final /* synthetic */ PriorityQueue<Pair<Long, Long>> $fragmentedFiles;
            final /* synthetic */ Ref.LongRef $totalFreeBytes;
            final /* synthetic */ Ref.LongRef $totalCleanableBytes;
            final /* synthetic */ UtilizationProfile this$0;
            {
                this.$fragmentedFiles = $fragmentedFiles;
                this.$totalFreeBytes = $totalFreeBytes;
                this.$totalCleanableBytes = $totalCleanableBytes;
                this.this$0 = $receiver;
            }

            public boolean hasNext() {
                return !this.$fragmentedFiles.isEmpty() && this.$totalFreeBytes.element > this.$totalCleanableBytes.element * (long)UtilizationProfile.access$getGc$p(this.this$0).getMaximumFreeSpacePercent$xodus_environment() / 100L;
            }

            @NotNull
            public Long next() {
                Pair<Long, Long> pair = this.$fragmentedFiles.poll();
                long l = this.$totalFreeBytes.element;
                Object object = pair.getSecond();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.second");
                this.$totalFreeBytes.element = l - ((Number)object).longValue();
                object = pair.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.first");
                return (Long)object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public final void loadUtilizationFromFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.gc.getCleaner$xodus_environment().getJobProcessor().queueAt((Job)new GcJob(this.gc, (Function0<Unit>)((Function0)new Function0<Unit>(path, this){
            final /* synthetic */ String $path;
            final /* synthetic */ UtilizationProfile this$0;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$synchronized$iv;
                Object object;
                LongHashMap usedSpace = new LongHashMap(0, 0.0f, 3, null);
                try {
                    Closeable closeable = new Scanner(new File(this.$path));
                    object = null;
                    try {
                        Scanner scanner = (Scanner)closeable;
                        boolean bl = false;
                        while (scanner.hasNextLong()) {
                            long address = scanner.nextLong();
                            long usedBytes = scanner.nextLong();
                            Map map = (Map)usedSpace;
                            Long l = address;
                            Long l2 = usedBytes;
                            map.put(l, l2);
                        }
                        scanner = Unit.INSTANCE;
                    }
                    catch (Throwable scanner) {
                        object = scanner;
                        throw scanner;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                }
                catch (Throwable t) {
                    GarbageCollector.Companion.loggingError$xodus_environment(t, (Function0<String>)((Function0)new Function0<String>(this.$path){
                        final /* synthetic */ String $path;
                        {
                            this.$path = $path;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return Intrinsics.stringPlus((String)"Failed to load utilization from ", (Object)this.$path);
                        }
                    }));
                }
                LongHashMap t = UtilizationProfile.access$getFilesUtilization$p(this.this$0);
                object = this.this$0;
                boolean $i$f$synchronized = false;
                synchronized ($this$synchronized$iv) {
                    boolean bl = false;
                    void $this$invoke_u24lambda_u2d1 = $this$synchronized$iv;
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u2d1.clear();
                    ((UtilizationProfile)object).setUtilization$xodus_environment((LongHashMap<Long>)usedSpace);
                    Unit unit = Unit.INSTANCE;
                }
            }
        })), this.gc.getStartTime$xodus_environment());
    }

    public final void computeUtilizationFromScratch() {
        GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)computeUtilizationFromScratch.1.INSTANCE));
        this.gc.getCleaner$xodus_environment().getJobProcessor().queueAt((Job)new ComputeUtilizationFromScratchJob(this.gc), this.gc.getStartTime$xodus_environment());
    }

    public final void estimateTotalBytesAndWakeGcIfNecessary$xodus_environment() {
        this.estimateTotalBytes$xodus_environment();
        if (this.gc.isTooMuchFreeSpace$xodus_environment()) {
            GarbageCollector.wake$default(this.gc, false, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUtilization$xodus_environment(@NotNull LongHashMap<Long> usedSpace) {
        Intrinsics.checkNotNullParameter(usedSpace, (String)"usedSpace");
        LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<MutableLong> $this$setUtilization_u24lambda_u2d21 = $this$synchronized$iv;
            boolean bl2 = false;
            for (Map.Entry entry : ((Map)usedSpace).entrySet()) {
                MutableLong mutableLong;
                Long fileAddress = (Long)entry.getKey();
                Long usedBytes = (Long)entry.getValue();
                MutableLong mutableLong2 = (MutableLong)$this$setUtilization_u24lambda_u2d21.get((Object)fileAddress);
                if (mutableLong2 == null) {
                    MutableLong mutableLong3;
                    MutableLong it = mutableLong3 = new MutableLong(0L);
                    boolean bl3 = false;
                    ((Map)$this$setUtilization_u24lambda_u2d21).put(fileAddress, it);
                    mutableLong = mutableLong3;
                } else {
                    mutableLong = mutableLong2;
                }
                MutableLong mutableLong4 = mutableLong;
                long l = mutableLong4.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)usedBytes, (String)"usedBytes");
                mutableLong4.setValue(l + Math.max(this.fileSize - usedBytes, 0L));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearUtilization() {
        LongHashMap<MutableLong> $this$synchronized$iv = this.filesUtilization;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<MutableLong> $this$clearUtilization_u24lambda_u2d22 = $this$synchronized$iv;
            boolean bl2 = false;
            $this$clearUtilization_u24lambda_u2d22.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void load$lambda-6(UtilizationProfile this$0, Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        if (!this$0.env.storeExists("exodus.gc.up", txn)) {
            if (this$0.env.getAllStoreCount() == 0L && this$0.log.getNumberOfFiles() <= 1L) {
                this$0.clearUtilization();
            } else {
                this$0.computeUtilizationFromScratch();
            }
        } else {
            boolean inconsistent;
            boolean bl;
            LongHashMap filesUtilization;
            block18: {
                filesUtilization = new LongHashMap(0, 0.0f, 3, null);
                Object object = this$0.env.openStore("exodus.gc.up", StoreConfig.WITHOUT_DUPLICATES, txn);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.openStore(GarbageCol\u2026.WITHOUT_DUPLICATES, txn)");
                StoreImpl store = object;
                object = (Closeable)store.openCursor(txn);
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)object;
                    bl = false;
                    while (cursor.getNext()) {
                        long fileAddress = LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey());
                        long l = CompressedUnsignedLongByteIterable.getLong(cursor.getValue());
                        if (l == 0L) continue;
                        Map map = (Map)filesUtilization;
                        Long l2 = fileAddress;
                        MutableLong mutableLong = new MutableLong(l);
                        map.put(l2, mutableLong);
                    }
                    cursor = Unit.INSTANCE;
                }
                catch (Throwable cursor) {
                    throwable = cursor;
                    throw cursor;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                inconsistent = false;
                PackedLongHashSet $this$load_u24lambda_u2d6_u24lambda_u2d4 = new PackedLongHashSet((Collection)filesUtilization.keySet(), 0.0f, 2, null);
                bl = false;
                long[] $this$forEach$iv = this$0.log.getAllFileAddresses();
                boolean $i$f$forEach = false;
                for (long element$iv : $this$forEach$iv) {
                    long it = element$iv;
                    boolean bl2 = false;
                    if ($this$load_u24lambda_u2d6_u24lambda_u2d4.remove((Object)it)) continue;
                    inconsistent = true;
                    break block18;
                }
                if (!((Collection)$this$load_u24lambda_u2d6_u24lambda_u2d4).isEmpty()) {
                    inconsistent = true;
                }
            }
            if (inconsistent) {
                this$0.computeUtilizationFromScratch();
            } else {
                LongHashMap<MutableLong> $this$synchronized$iv = this$0.filesUtilization;
                boolean $i$f$synchronized = false;
                synchronized ($this$synchronized$iv) {
                    bl = false;
                    LongHashMap<MutableLong> $this$load_u24lambda_u2d6_u24lambda_u2d5 = $this$synchronized$iv;
                    boolean bl3 = false;
                    $this$load_u24lambda_u2d6_u24lambda_u2d5.clear();
                    $this$load_u24lambda_u2d6_u24lambda_u2d5.putAll((Map)filesUtilization);
                    Unit unit = Unit.INSTANCE;
                }
                this$0.estimateTotalBytesAndWakeGcIfNecessary$xodus_environment();
            }
        }
    }

    private static final int getFilesSortedByUtilization$lambda-17(Pair leftPair, Pair rightPair) {
        Long rightFreeBytes;
        Long leftFreeBytes = (Long)leftPair.getSecond();
        if (Intrinsics.areEqual((Object)leftFreeBytes, (Object)(rightFreeBytes = (Long)rightPair.getSecond()))) {
            return 0;
        }
        Intrinsics.checkNotNullExpressionValue((Object)leftFreeBytes, (String)"leftFreeBytes");
        long l = leftFreeBytes;
        Intrinsics.checkNotNullExpressionValue((Object)rightFreeBytes, (String)"rightFreeBytes");
        return l > rightFreeBytes ? -1 : 1;
    }

    public static final /* synthetic */ GarbageCollector access$getGc$p(UtilizationProfile $this) {
        return $this.gc;
    }

    public static final /* synthetic */ Log access$getLog$p(UtilizationProfile $this) {
        return $this.log;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\n"}, d2={"Ljetbrains/exodus/gc/UtilizationProfile$MutableLong;", "", "value", "", "(J)V", "getValue", "()J", "setValue", "toString", "", "xodus-environment"})
    private static final class MutableLong {
        private long value;

        public MutableLong(long value) {
            this.value = value;
        }

        public final long getValue() {
            return this.value;
        }

        public final void setValue(long l) {
            this.value = l;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

