/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BasePage;
import org.jetbrains.annotations.NotNull;

public class BTreeBalancePolicy {
    public static BTreeBalancePolicy DEFAULT = new BTreeBalancePolicy(128, 32);
    private final int maxSize;
    private final int maxDupSize;

    public BTreeBalancePolicy(int maxSize) {
        this(maxSize, maxSize);
    }

    public BTreeBalancePolicy(int maxSize, int maxDupSize) {
        this.maxSize = maxSize;
        this.maxDupSize = maxDupSize;
    }

    public int getPageMaxSize() {
        return this.maxSize;
    }

    public int getDupPageMaxSize() {
        return this.maxDupSize;
    }

    public boolean needSplit(@NotNull BasePage page) {
        return page.getSize() >= (BTreeBalancePolicy.isDupTree(page) ? this.getDupPageMaxSize() : this.getPageMaxSize());
    }

    public int getSplitPos(@NotNull BasePage page, int insertPosition) {
        int pageSize = page.getSize();
        return insertPosition < pageSize ? pageSize >> 1 : pageSize * 7 >> 3;
    }

    public boolean needMerge(@NotNull BasePage left, @NotNull BasePage right) {
        int leftSize = left.getSize();
        int rightSize = right.getSize();
        return leftSize == 0 || rightSize == 0 || leftSize + rightSize <= (BTreeBalancePolicy.isDupTree(left) ? this.getDupPageMaxSize() : this.getPageMaxSize()) * 7 >> 3;
    }

    private static boolean isDupTree(@NotNull BasePage page) {
        return ((BTreeMutable)page.tree).isDup();
    }
}

