/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.encryption;

import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import org.apache.nifi.repository.encryption.AesSecretKeyRepositoryEncryptor;
import org.apache.nifi.repository.encryption.RepositoryEncryptionException;
import org.apache.nifi.repository.encryption.configuration.EncryptionMetadataHeader;
import org.apache.nifi.repository.encryption.configuration.RepositoryEncryptionMethod;
import org.apache.nifi.repository.encryption.metadata.RecordMetadata;
import org.apache.nifi.security.kms.KeyProvider;

public class AesGcmByteArrayRepositoryEncryptor
extends AesSecretKeyRepositoryEncryptor<byte[], byte[]> {
    public AesGcmByteArrayRepositoryEncryptor(KeyProvider keyProvider, EncryptionMetadataHeader encryptionMetadataHeader) {
        super(RepositoryEncryptionMethod.AES_GCM, keyProvider, encryptionMetadataHeader);
    }

    @Override
    public byte[] decrypt(byte[] record, String recordId) {
        try {
            RecordMetadata metadata = this.readMetadata(new ByteArrayInputStream(record));
            Cipher cipher = this.getDecryptionCipher(metadata.getKeyId(), metadata.getInitializationVector());
            int cipherLength = metadata.getLength();
            int startIndex = record.length - cipherLength;
            return cipher.doFinal(record, startIndex, cipherLength);
        }
        catch (GeneralSecurityException e) {
            throw new RepositoryEncryptionException(String.format("Decryption Failed for Record ID [%s]", recordId), e);
        }
    }

    @Override
    protected byte[] encrypt(byte[] record, String recordId, String keyId, Cipher cipher) {
        try {
            byte[] encryptedRecord = cipher.doFinal(record);
            byte[] serializedMetadata = this.getMetadata(keyId, cipher.getIV(), encryptedRecord.length);
            return this.concatenate(serializedMetadata, encryptedRecord);
        }
        catch (GeneralSecurityException e) {
            throw new RepositoryEncryptionException(String.format("Encryption Failed for Record ID [%s]", recordId), e);
        }
    }

    private byte[] concatenate(byte[] serializedMetadata, byte[] encryptedRecord) {
        int concatenatedLength = serializedMetadata.length + encryptedRecord.length;
        byte[] concatenated = new byte[concatenatedLength];
        System.arraycopy(serializedMetadata, 0, concatenated, 0, serializedMetadata.length);
        System.arraycopy(encryptedRecord, 0, concatenated, serializedMetadata.length, encryptedRecord.length);
        return concatenated;
    }
}

