/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web.converter;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.oidc.OidcConfigurationException;
import org.apache.nifi.web.security.oidc.client.web.OidcAuthorizedClient;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.client.web.converter.AuthorizedClient;
import org.apache.nifi.web.security.oidc.client.web.converter.AuthorizedClientConverter;
import org.apache.nifi.web.security.oidc.client.web.converter.AuthorizedToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;

public class StandardAuthorizedClientConverter
implements AuthorizedClientConverter {
    private static final Logger logger = LoggerFactory.getLogger(StandardAuthorizedClientConverter.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModules(new Module[]{new JavaTimeModule()});
    private final PropertyEncryptor propertyEncryptor;
    private final ClientRegistrationRepository clientRegistrationRepository;

    public StandardAuthorizedClientConverter(PropertyEncryptor propertyEncryptor, ClientRegistrationRepository clientRegistrationRepository) {
        this.propertyEncryptor = Objects.requireNonNull(propertyEncryptor, "Property Encryptor required");
        this.clientRegistrationRepository = Objects.requireNonNull(clientRegistrationRepository, "Client Registry Repository required");
    }

    @Override
    public String getEncoded(OidcAuthorizedClient oidcAuthorizedClient) {
        Objects.requireNonNull(oidcAuthorizedClient, "Authorized Client required");
        try {
            AuthorizedClient authorizedClient = this.writeAuthorizedClient(oidcAuthorizedClient);
            String serialized = OBJECT_MAPPER.writeValueAsString((Object)authorizedClient);
            return this.propertyEncryptor.encrypt(serialized);
        }
        catch (Exception e) {
            throw new OidcConfigurationException("OIDC Authorized Client serialization failed", e);
        }
    }

    @Override
    public OidcAuthorizedClient getDecoded(String encoded) {
        Objects.requireNonNull(encoded, "Encoded representation required");
        try {
            String decrypted = this.propertyEncryptor.decrypt(encoded);
            AuthorizedClient authorizedClient = (AuthorizedClient)OBJECT_MAPPER.readValue(decrypted, AuthorizedClient.class);
            return this.readAuthorizedClient(authorizedClient);
        }
        catch (Exception e) {
            logger.warn("OIDC Authorized Client decoding failed", (Throwable)e);
            return null;
        }
    }

    private AuthorizedClient writeAuthorizedClient(OidcAuthorizedClient oidcAuthorizedClient) {
        OAuth2AccessToken oidcAccessToken = oidcAuthorizedClient.getAccessToken();
        AuthorizedToken accessToken = new AuthorizedToken(oidcAccessToken.getTokenValue(), oidcAccessToken.getIssuedAt(), oidcAccessToken.getExpiresAt());
        OAuth2RefreshToken oidcRefreshToken = oidcAuthorizedClient.getRefreshToken();
        AuthorizedToken refreshToken = oidcRefreshToken == null ? null : new AuthorizedToken(oidcRefreshToken.getTokenValue(), oidcRefreshToken.getIssuedAt(), oidcRefreshToken.getExpiresAt());
        OidcIdToken oidcIdToken = oidcAuthorizedClient.getIdToken();
        AuthorizedToken idToken = new AuthorizedToken(oidcIdToken.getTokenValue(), oidcIdToken.getIssuedAt(), oidcIdToken.getExpiresAt());
        String principalName = oidcAuthorizedClient.getPrincipalName();
        return new AuthorizedClient(principalName, accessToken, refreshToken, idToken);
    }

    private OidcAuthorizedClient readAuthorizedClient(AuthorizedClient authorizedClient) {
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(OidcRegistrationProperty.REGISTRATION_ID.getProperty());
        String principalName = authorizedClient.getPrincipalName();
        OAuth2AccessToken accessToken = this.getAccessToken(authorizedClient.getAccessToken());
        OAuth2RefreshToken refreshToken = this.getRefreshToken(authorizedClient.getRefreshToken());
        OidcIdToken idToken = this.getIdToken(authorizedClient);
        return new OidcAuthorizedClient(clientRegistration, principalName, accessToken, refreshToken, idToken);
    }

    private OAuth2AccessToken getAccessToken(AuthorizedToken authorizedToken) {
        return new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, authorizedToken.getTokenValue(), authorizedToken.getIssuedAt(), authorizedToken.getExpiresAt());
    }

    private OAuth2RefreshToken getRefreshToken(AuthorizedToken authorizedToken) {
        return authorizedToken == null ? null : new OAuth2RefreshToken(authorizedToken.getTokenValue(), authorizedToken.getIssuedAt(), authorizedToken.getExpiresAt());
    }

    private OidcIdToken getIdToken(AuthorizedClient authorizedClient) {
        AuthorizedToken authorizedToken = authorizedClient.getIdToken();
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
        claims.put(SupportedClaim.SUBJECT.getClaim(), authorizedClient.getPrincipalName());
        claims.put(SupportedClaim.ISSUED_AT.getClaim(), authorizedToken.getIssuedAt());
        claims.put(SupportedClaim.EXPIRATION.getClaim(), authorizedToken.getExpiresAt());
        return new OidcIdToken(authorizedToken.getTokenValue(), authorizedToken.getIssuedAt(), authorizedToken.getExpiresAt(), claims);
    }
}

