/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.registration;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.saml2.SamlUrlPath;
import org.apache.nifi.web.security.saml2.registration.Saml2CredentialProvider;
import org.apache.nifi.web.security.saml2.registration.Saml2RegistrationProperty;
import org.apache.nifi.web.security.saml2.registration.StandardRegistrationBuilderProvider;
import org.apache.nifi.web.security.saml2.registration.StandardSaml2CredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;

public class StandardRelyingPartyRegistrationRepository
implements RelyingPartyRegistrationRepository {
    static final String BASE_URL_FORMAT = "{baseUrl}%s";
    static final String LOGIN_RESPONSE_LOCATION = String.format("{baseUrl}%s", SamlUrlPath.LOGIN_RESPONSE.getPath());
    static final String SINGLE_LOGOUT_RESPONSE_SERVICE_LOCATION = String.format("{baseUrl}%s", SamlUrlPath.SINGLE_LOGOUT_RESPONSE.getPath());
    private static final char[] BLANK_PASSWORD = new char[0];
    private static final Logger logger = LoggerFactory.getLogger(StandardRelyingPartyRegistrationRepository.class);
    private final Saml2CredentialProvider saml2CredentialProvider = new StandardSaml2CredentialProvider();
    private final NiFiProperties properties;
    private final RelyingPartyRegistration relyingPartyRegistration;

    public StandardRelyingPartyRegistrationRepository(NiFiProperties properties) {
        this.properties = properties;
        this.relyingPartyRegistration = this.getRelyingPartyRegistration();
    }

    public RelyingPartyRegistration findByRegistrationId(String registrationId) {
        return this.relyingPartyRegistration;
    }

    private RelyingPartyRegistration getRelyingPartyRegistration() {
        StandardRegistrationBuilderProvider registrationBuilderProvider = new StandardRegistrationBuilderProvider(this.properties);
        RelyingPartyRegistration.Builder builder = registrationBuilderProvider.getRegistrationBuilder();
        builder.registrationId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty());
        String entityId = this.properties.getSamlServiceProviderEntityId();
        builder.entityId(entityId);
        builder.assertionConsumerServiceLocation(LOGIN_RESPONSE_LOCATION);
        if (this.properties.isSamlSingleLogoutEnabled()) {
            builder.singleLogoutServiceLocation(SINGLE_LOGOUT_RESPONSE_SERVICE_LOCATION);
            builder.singleLogoutServiceResponseLocation(SINGLE_LOGOUT_RESPONSE_SERVICE_LOCATION);
        }
        Collection<Saml2X509Credential> configuredCredentials = this.getCredentials();
        List signingCredentials = configuredCredentials.stream().filter(Saml2X509Credential::isSigningCredential).collect(Collectors.toList());
        logger.debug("Loaded SAML2 Signing Credentials [{}]", (Object)signingCredentials.size());
        builder.signingX509Credentials(credentials -> credentials.addAll(signingCredentials));
        builder.decryptionX509Credentials(credentials -> credentials.addAll(signingCredentials));
        List verificationCredentials = configuredCredentials.stream().filter(Saml2X509Credential::isVerificationCredential).collect(Collectors.toList());
        logger.debug("Loaded SAML2 Verification Credentials [{}]", (Object)verificationCredentials.size());
        builder.assertingPartyDetails(assertingPartyDetails -> assertingPartyDetails.signingAlgorithms(signingAlgorithms -> signingAlgorithms.add(this.properties.getSamlSignatureAlgorithm())).verificationX509Credentials(credentials -> credentials.addAll(verificationCredentials)).encryptionX509Credentials(credentials -> credentials.addAll(verificationCredentials)));
        return builder.build();
    }

    private Collection<Saml2X509Credential> getCredentials() {
        TlsConfiguration tlsConfiguration = StandardTlsConfiguration.fromNiFiProperties((NiFiProperties)this.properties);
        ArrayList<Saml2X509Credential> credentials = new ArrayList<Saml2X509Credential>();
        if (tlsConfiguration.isKeystorePopulated()) {
            KeyStore keyStore = this.getKeyStore(tlsConfiguration);
            char[] keyPassword = tlsConfiguration.getKeyPassword() == null ? tlsConfiguration.getKeystorePassword().toCharArray() : tlsConfiguration.getKeyPassword().toCharArray();
            Collection<Saml2X509Credential> keyStoreCredentials = this.saml2CredentialProvider.getCredentials(keyStore, keyPassword);
            credentials.addAll(keyStoreCredentials);
        }
        if (tlsConfiguration.isTruststorePopulated()) {
            KeyStore trustStore = this.getTrustStore(tlsConfiguration);
            Collection<Saml2X509Credential> trustStoreCredentials = this.saml2CredentialProvider.getCredentials(trustStore, BLANK_PASSWORD);
            credentials.addAll(trustStoreCredentials);
        }
        return credentials;
    }

    private KeyStore getTrustStore(TlsConfiguration tlsConfiguration) {
        try {
            return KeyStoreUtils.loadKeyStore((String)tlsConfiguration.getTruststorePath(), (char[])tlsConfiguration.getTruststorePassword().toCharArray(), (String)tlsConfiguration.getTruststoreType().getType());
        }
        catch (TlsException e) {
            throw new Saml2Exception("Trust Store loading failed", (Throwable)e);
        }
    }

    private KeyStore getKeyStore(TlsConfiguration tlsConfiguration) {
        try {
            return KeyStoreUtils.loadKeyStore((String)tlsConfiguration.getKeystorePath(), (char[])tlsConfiguration.getKeystorePassword().toCharArray(), (String)tlsConfiguration.getKeystoreType().getType());
        }
        catch (TlsException e) {
            throw new Saml2Exception("Key Store loading failed", (Throwable)e);
        }
    }
}

