/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XksProxyAuthenticationCredentialType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, XksProxyAuthenticationCredentialType> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessKeyId").getter(XksProxyAuthenticationCredentialType.getter(XksProxyAuthenticationCredentialType::accessKeyId)).setter(XksProxyAuthenticationCredentialType.setter(Builder::accessKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()}).build();
    private static final SdkField<String> RAW_SECRET_ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RawSecretAccessKey").getter(XksProxyAuthenticationCredentialType.getter(XksProxyAuthenticationCredentialType::rawSecretAccessKey)).setter(XksProxyAuthenticationCredentialType.setter(Builder::rawSecretAccessKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawSecretAccessKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD, RAW_SECRET_ACCESS_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccessKeyId", ACCESS_KEY_ID_FIELD);
            this.put("RawSecretAccessKey", RAW_SECRET_ACCESS_KEY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accessKeyId;
    private final String rawSecretAccessKey;

    private XksProxyAuthenticationCredentialType(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.rawSecretAccessKey = builder.rawSecretAccessKey;
    }

    public final String accessKeyId() {
        return this.accessKeyId;
    }

    public final String rawSecretAccessKey() {
        return this.rawSecretAccessKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawSecretAccessKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XksProxyAuthenticationCredentialType)) {
            return false;
        }
        XksProxyAuthenticationCredentialType other = (XksProxyAuthenticationCredentialType)obj;
        return Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.rawSecretAccessKey(), other.rawSecretAccessKey());
    }

    public final String toString() {
        return ToString.builder((String)"XksProxyAuthenticationCredentialType").add("AccessKeyId", (Object)(this.accessKeyId() == null ? null : "*** Sensitive Data Redacted ***")).add("RawSecretAccessKey", (Object)(this.rawSecretAccessKey() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "RawSecretAccessKey": {
                return Optional.ofNullable(clazz.cast(this.rawSecretAccessKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<XksProxyAuthenticationCredentialType, T> g) {
        return obj -> g.apply((XksProxyAuthenticationCredentialType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessKeyId;
        private String rawSecretAccessKey;

        private BuilderImpl() {
        }

        private BuilderImpl(XksProxyAuthenticationCredentialType model) {
            this.accessKeyId(model.accessKeyId);
            this.rawSecretAccessKey(model.rawSecretAccessKey);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final String getRawSecretAccessKey() {
            return this.rawSecretAccessKey;
        }

        public final void setRawSecretAccessKey(String rawSecretAccessKey) {
            this.rawSecretAccessKey = rawSecretAccessKey;
        }

        @Override
        public final Builder rawSecretAccessKey(String rawSecretAccessKey) {
            this.rawSecretAccessKey = rawSecretAccessKey;
            return this;
        }

        public XksProxyAuthenticationCredentialType build() {
            return new XksProxyAuthenticationCredentialType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, XksProxyAuthenticationCredentialType> {
        public Builder accessKeyId(String var1);

        public Builder rawSecretAccessKey(String var1);
    }
}

