/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.std.LowerCaseAsciiCharSequenceObjHashMap;
import io.questdb.std.ObjList;

public final class OperatorExpression {
    public static final int BINARY = 2;
    public static final int DOT_PRECEDENCE = 1;
    public static final int SET = 3;
    public static final int UNARY = 1;
    static final ObjList<OperatorExpression> operators = new ObjList<OperatorExpression>(){
        {
            this.add(new OperatorExpression(".", 1, false, 2));
            this.add(new OperatorExpression("::", 1, true, 2));
            this.add(new OperatorExpression("*", 3, true, 2));
            this.add(new OperatorExpression("/", 3, true, 2));
            this.add(new OperatorExpression("%", 3, true, 2));
            this.add(new OperatorExpression("+", 4, true, 2));
            this.add(new OperatorExpression("-", 4, true, 2));
            this.add(new OperatorExpression("||", 5, true, 2));
            this.add(new OperatorExpression("<", 6, true, 2));
            this.add(new OperatorExpression("<=", 6, true, 2));
            this.add(new OperatorExpression(">", 6, true, 2));
            this.add(new OperatorExpression(">=", 6, true, 2));
            this.add(new OperatorExpression("=", 7, true, 2));
            this.add(new OperatorExpression("~", 7, true, 2));
            this.add(new OperatorExpression("!=", 7, true, 2));
            this.add(new OperatorExpression("<>", 7, true, 2));
            this.add(new OperatorExpression("!~", 7, true, 2));
            this.add(new OperatorExpression("in", 7, true, 3, false));
            this.add(new OperatorExpression("between", 7, true, 3, false));
            this.add(new OperatorExpression("&", 8, true, 2));
            this.add(new OperatorExpression("^", 9, false, 2));
            this.add(new OperatorExpression("|", 10, true, 2));
            this.add(new OperatorExpression("and", 11, true, 2, false));
            this.add(new OperatorExpression("or", 11, true, 2, false));
            this.add(new OperatorExpression("not", 11, true, 1, false));
            this.add(new OperatorExpression("like", 7, true, 2, false));
            this.add(new OperatorExpression("ilike", 7, true, 2, false));
            this.add(new OperatorExpression("within", 7, true, 3, false));
        }
    };
    static final LowerCaseAsciiCharSequenceObjHashMap<OperatorExpression> opMap = new LowerCaseAsciiCharSequenceObjHashMap<OperatorExpression>(){
        {
            int k = operators.size();
            for (int i = 0; i < k; ++i) {
                OperatorExpression op = operators.getQuick(i);
                this.put(op.token, op);
            }
        }
    };
    final boolean leftAssociative;
    final int precedence;
    final boolean symbol;
    final String token;
    final int type;

    private OperatorExpression(String token, int precedence, boolean leftAssociative, int type, boolean symbol) {
        this.token = token;
        this.precedence = precedence;
        this.leftAssociative = leftAssociative;
        this.type = type;
        this.symbol = symbol;
    }

    private OperatorExpression(String token, int precedence, boolean leftAssociative, int type) {
        this.token = token;
        this.precedence = precedence;
        this.leftAssociative = leftAssociative;
        this.type = type;
        this.symbol = true;
    }

    public static int getOperatorType(CharSequence name) {
        int index = opMap.keyIndex(name);
        if (index < 0) {
            return OperatorExpression.opMap.valueAt((int)index).type;
        }
        return 0;
    }

    public static boolean isOperator(CharSequence name) {
        return opMap.keyIndex(name) < 0;
    }
}

