/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLongHashSet;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class CompactLongHashSet
extends AbstractLongHashSet {
    private static final int MIN_INITIAL_CAPACITY = 16;

    public CompactLongHashSet() {
        this(16);
    }

    public CompactLongHashSet(int initialCapacity) {
        this(initialCapacity, 0.6, -1L);
    }

    public CompactLongHashSet(int initialCapacity, double loadFactor, long noKeyValue) {
        super(initialCapacity, loadFactor, noKeyValue);
        this.clear();
    }

    public boolean add(long key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public void addAt(int index, long key) {
        this.keys[index] = key;
        if (--this.free < 1) {
            this.rehash();
        }
    }

    public boolean contains(long key) {
        return this.keyIndex(key) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactLongHashSet that = (CompactLongHashSet)o;
        if (this.size() != that.size()) {
            return false;
        }
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == this.noEntryKeyValue || !that.excludes(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean excludes(long key) {
        return this.keyIndex(key) > -1;
    }

    public int hashCode() {
        int hashCode = 0;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == this.noEntryKeyValue) continue;
            hashCode = (int)((long)hashCode + this.keys[i]);
        }
        return hashCode;
    }

    public String toString() {
        return Arrays.toString(this.keys);
    }

    private void rehash() {
        int newCapacity;
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        long[] oldKeys = this.keys;
        this.keys = new long[len];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.mask = len - 1;
        for (long key : oldKeys) {
            if (key == this.noEntryKeyValue) continue;
            this.keys[this.keyIndex((long)key)] = key;
            --this.free;
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }
}

