/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.flow;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.nifi.registry.flow.FlowPersistenceException;
import org.apache.nifi.registry.flow.FlowPersistenceProvider;
import org.apache.nifi.registry.flow.FlowSnapshotContext;
import org.apache.nifi.registry.provider.ProviderConfigurationContext;
import org.apache.nifi.registry.provider.ProviderContext;
import org.apache.nifi.registry.provider.ProviderCreationException;
import org.springframework.jdbc.core.JdbcTemplate;

public class DatabaseFlowPersistenceProvider
implements FlowPersistenceProvider {
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;

    @ProviderContext
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
    }

    public void onConfigured(ProviderConfigurationContext configurationContext) throws ProviderCreationException {
    }

    public void saveFlowContent(FlowSnapshotContext context, byte[] content) throws FlowPersistenceException {
        String sql = "INSERT INTO FLOW_PERSISTENCE_PROVIDER (BUCKET_ID, FLOW_ID, VERSION, FLOW_CONTENT) VALUES (?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO FLOW_PERSISTENCE_PROVIDER (BUCKET_ID, FLOW_ID, VERSION, FLOW_CONTENT) VALUES (?, ?, ?, ?)", new Object[]{context.getBucketId(), context.getFlowId(), context.getVersion(), content});
    }

    public byte[] getFlowContent(String bucketId, String flowId, int version) throws FlowPersistenceException {
        ArrayList results = new ArrayList();
        String sql = "SELECT FLOW_CONTENT FROM FLOW_PERSISTENCE_PROVIDER WHERE BUCKET_ID = ? and FLOW_ID = ? and VERSION = ?";
        this.jdbcTemplate.query("SELECT FLOW_CONTENT FROM FLOW_PERSISTENCE_PROVIDER WHERE BUCKET_ID = ? and FLOW_ID = ? and VERSION = ?", rs -> {
            byte[] content = rs.getBytes("FLOW_CONTENT");
            results.add(content);
        }, new Object[]{bucketId, flowId, version});
        if (results.isEmpty()) {
            return null;
        }
        return (byte[])results.get(0);
    }

    public void deleteAllFlowContent(String bucketId, String flowId) throws FlowPersistenceException {
        String sql = "DELETE FROM FLOW_PERSISTENCE_PROVIDER WHERE BUCKET_ID = ? and FLOW_ID = ?";
        this.jdbcTemplate.update("DELETE FROM FLOW_PERSISTENCE_PROVIDER WHERE BUCKET_ID = ? and FLOW_ID = ?", new Object[]{bucketId, flowId});
    }

    public void deleteFlowContent(String bucketId, String flowId, int version) throws FlowPersistenceException {
        String sql = "DELETE FROM FLOW_PERSISTENCE_PROVIDER WHERE BUCKET_ID = ? and FLOW_ID = ? and VERSION = ?";
        this.jdbcTemplate.update("DELETE FROM FLOW_PERSISTENCE_PROVIDER WHERE BUCKET_ID = ? and FLOW_ID = ? and VERSION = ?", new Object[]{bucketId, flowId, version});
    }
}

