/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authorization.AllAuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.RequiredAuthoritiesRepository;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class RequiredAuthoritiesAuthorizationManager<T>
implements AuthorizationManager<T> {
    private final RequiredAuthoritiesRepository authorities;

    public RequiredAuthoritiesAuthorizationManager(RequiredAuthoritiesRepository authorities) {
        Assert.notNull((Object)authorities, (String)"authorities cannot be null");
        this.authorities = authorities;
    }

    @Override
    public @Nullable AuthorizationResult authorize(Supplier<? extends @Nullable Authentication> authentication, T object) {
        List<String> authorities = this.findAuthorities(authentication.get());
        if (authorities.isEmpty()) {
            return new AuthorizationDecision(true);
        }
        AllAuthoritiesAuthorizationManager delegate = AllAuthoritiesAuthorizationManager.hasAllAuthorities(authorities);
        return delegate.authorize((Supplier)authentication, (Object)object);
    }

    private List<String> findAuthorities(@Nullable Authentication authentication) {
        if (authentication == null) {
            return List.of();
        }
        String username = authentication.getName();
        return this.authorities.findRequiredAuthorities(username);
    }
}

