/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable;

import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.CWC_LongestWord;
import java.util.LinkedList;
import org.apache.commons.lang3.Validate;

public class CWC_LongestWordMax
implements AT_ColumnWidthCalculator {
    protected int max;
    protected int[] maxAr;

    public CWC_LongestWordMax(int max) {
        Validate.validState((max >= 3 ? 1 : 0) != 0, (String)"maximum column width cannot be smaller than 3", (Object[])new Object[0]);
        this.max = max;
    }

    public CWC_LongestWordMax(int[] maxAr) {
        Validate.notNull((Object)maxAr);
        for (int m : maxAr) {
            if (m == -1 || m >= 3) continue;
            throw new IllegalArgumentException("array contains maximum column width smaller than 3");
        }
        this.maxAr = maxAr;
    }

    @Override
    public int[] calculateColumnWidths(LinkedList<AT_Row> rows, int colNumbers, int tableWidth) {
        Validate.notNull(rows);
        if (this.maxAr != null && this.maxAr.length != colNumbers) {
            throw new IllegalArgumentException("maxAr length is not the same as rows in the table");
        }
        int[] ret = CWC_LongestWord.longestWord(rows, colNumbers);
        for (int i = 0; i < ret.length; ++i) {
            if (this.max != 0) {
                if (ret[i] <= this.max) continue;
                ret[i] = this.max;
                continue;
            }
            if (this.maxAr == null || this.maxAr[i] == -1 || ret[i] <= this.maxAr[i]) continue;
            ret[i] = this.maxAr[i];
        }
        return ret;
    }
}

