/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlSelectableTextInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HtmlEmailInput
extends HtmlSelectableTextInput
implements LabelableElement {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("^[a-zA-Z\\d.!#$%&'*+/=?^_`{|\\}~-]+@[a-zA-Z\\d](?:[a-zA-Z\\d-]{0,61}[a-zA-Z\\d])?(?:\\.[a-zA-Z\\d](?:[a-zA-Z\\d-]{0,61}[a-zA-Z\\d])?)*$");

    HtmlEmailInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        String value = this.getValueAttribute();
        if (!value.isEmpty()) {
            this.setValueAttribute(value);
        }
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        if ("value".equals(qualifiedName) && this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_EMAIL_TRIMMED)) {
            if (StringUtils.isBlank((CharSequence)attributeValue)) {
                super.setAttributeNS(namespaceURI, qualifiedName, "", notifyAttributeChangeListeners, notifyMutationObservers);
                return;
            }
            super.setAttributeNS(namespaceURI, qualifiedName, attributeValue.trim(), notifyAttributeChangeListeners, notifyMutationObservers);
            return;
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public boolean isValid() {
        boolean isValid = super.isValid();
        if (!isValid) {
            return false;
        }
        String val = this.getValueAttribute();
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return DEFAULT_PATTERN.matcher(val).matches();
        }
        return true;
    }

    @Override
    protected boolean isPatternSupported() {
        return true;
    }

    @Override
    protected boolean isBlankPatternValidated() {
        return false;
    }

    @Override
    protected boolean isMinMaxLengthSupported() {
        return true;
    }
}

