/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class HtmlTableRow
extends HtmlElement {
    public static final String TAG_NAME = "tr";

    HtmlTableRow(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public CellIterator getCellIterator() {
        return new CellIterator();
    }

    public List<HtmlTableCell> getCells() {
        ArrayList<HtmlTableCell> result = new ArrayList<HtmlTableCell>();
        for (HtmlTableCell cell : this.getCellIterator()) {
            result.add(cell);
        }
        return Collections.unmodifiableList(result);
    }

    public HtmlTableCell getCell(int index) throws IndexOutOfBoundsException {
        int count = 0;
        for (HtmlTableCell cell : this.getCellIterator()) {
            if (count == index) {
                return cell;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException("No cell found for index " + index + ".");
    }

    public final String getAlignAttribute() {
        return this.getAttributeDirect("align");
    }

    public final String getCharAttribute() {
        return this.getAttributeDirect("char");
    }

    public final String getCharoffAttribute() {
        return this.getAttributeDirect("charoff");
    }

    public final String getValignAttribute() {
        return this.getAttributeDirect("valign");
    }

    public HtmlTable getEnclosingTable() {
        return (HtmlTable)this.getEnclosingElement("table");
    }

    public final String getBgcolorAttribute() {
        return this.getAttributeDirect("bgcolor");
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.TABLE_ROW;
    }

    public class CellIterator
    implements Iterator<HtmlTableCell>,
    Iterable<HtmlTableCell> {
        private HtmlTableCell nextCell_;
        private HtmlForm currentForm_;

        public CellIterator() {
            this.setNextCell(HtmlTableRow.this.getFirstChild());
        }

        @Override
        public boolean hasNext() {
            return this.nextCell_ != null;
        }

        @Override
        public HtmlTableCell next() throws NoSuchElementException {
            return this.nextCell();
        }

        @Override
        public void remove() {
            if (this.nextCell_ == null) {
                throw new IllegalStateException();
            }
            DomNode sibling = this.nextCell_.getPreviousSibling();
            if (sibling != null) {
                sibling.remove();
            }
        }

        public HtmlTableCell nextCell() throws NoSuchElementException {
            if (this.nextCell_ != null) {
                HtmlTableCell result = this.nextCell_;
                this.setNextCell(this.nextCell_.getNextSibling());
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextCell(DomNode node) {
            this.nextCell_ = null;
            for (DomNode next = node; next != null; next = next.getNextSibling()) {
                if (next instanceof HtmlTableCell) {
                    this.nextCell_ = (HtmlTableCell)next;
                    return;
                }
                if (this.currentForm_ != null || !(next instanceof HtmlForm)) continue;
                this.currentForm_ = (HtmlForm)next;
                this.setNextCell(next.getFirstChild());
                return;
            }
            if (this.currentForm_ != null) {
                HtmlForm form = this.currentForm_;
                this.currentForm_ = null;
                this.setNextCell(form.getNextSibling());
            }
        }

        @Override
        public Iterator<HtmlTableCell> iterator() {
            return this;
        }
    }
}

