/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.htmlunit;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.nutch.protocol.htmlunit.HtmlUnitWebWindowListener;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlUnitWebDriver
extends HtmlUnitDriver {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean enableJavascript;
    private static boolean enableCss;
    private static boolean enableRedirect;
    private static long javascriptTimeout;
    private static int maxRedirects;

    public HtmlUnitWebDriver() {
        super(enableJavascript);
    }

    protected WebClient modifyWebClient(WebClient client) {
        client.getOptions().setJavaScriptEnabled(enableJavascript);
        client.getOptions().setCssEnabled(enableCss);
        client.getOptions().setRedirectEnabled(enableRedirect);
        if (enableJavascript) {
            client.setJavaScriptTimeout(javascriptTimeout);
        }
        client.getOptions().setThrowExceptionOnScriptError(false);
        if (enableRedirect) {
            client.addWebWindowListener((WebWindowListener)new HtmlUnitWebWindowListener(maxRedirects));
        }
        return client;
    }

    public static WebDriver getDriverForPage(String url, Configuration conf) {
        long pageLoadTimout = conf.getLong("page.load.delay", 3L);
        enableJavascript = conf.getBoolean("htmlunit.enable.javascript", true);
        enableCss = conf.getBoolean("htmlunit.enable.css", false);
        javascriptTimeout = conf.getLong("htmlunit.javascript.timeout", 3500L);
        int redirects = Integer.parseInt(conf.get("http.redirect.max", "0"));
        enableRedirect = redirects > 0;
        maxRedirects = redirects;
        HtmlUnitWebDriver driver = null;
        try {
            driver = new HtmlUnitWebDriver();
            driver.manage().timeouts().pageLoadTimeout(Duration.of(pageLoadTimout, ChronoUnit.SECONDS));
            driver.get(url);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                LOG.debug("HtmlUnit WebDriver: Timeout Exception: Capturing whatever loaded so far...");
                return driver;
            }
            HtmlUnitWebDriver.cleanUpDriver((WebDriver)driver);
            throw new RuntimeException(e);
        }
        return driver;
    }

    public static String getHTMLContent(WebDriver driver, Configuration conf) {
        try {
            if (conf.getBoolean("take.screenshot", false)) {
                HtmlUnitWebDriver.takeScreenshot(driver, conf);
            }
            String innerHtml = "";
            if (enableJavascript) {
                WebElement body = driver.findElement(By.tagName((String)"body"));
                innerHtml = (String)((JavascriptExecutor)driver).executeScript("return arguments[0].innerHTML;", new Object[]{body});
            } else {
                innerHtml = driver.getPageSource().replaceAll("&amp;", "&");
            }
            return innerHtml;
        }
        catch (Exception e) {
            TemporaryFilesystem.getDefaultTmpFS().deleteTemporaryFiles();
            HtmlUnitWebDriver.cleanUpDriver(driver);
            throw new RuntimeException(e);
        }
    }

    public static void cleanUpDriver(WebDriver driver) {
        if (driver != null) {
            try {
                driver.close();
                driver.quit();
                TemporaryFilesystem.getDefaultTmpFS().deleteTemporaryFiles();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String getHtmlPage(String url, Configuration conf) {
        WebDriver driver = HtmlUnitWebDriver.getDriverForPage(url, conf);
        try {
            if (conf.getBoolean("take.screenshot", false)) {
                HtmlUnitWebDriver.takeScreenshot(driver, conf);
            }
            String innerHtml = "";
            if (enableJavascript) {
                WebElement body = driver.findElement(By.tagName((String)"body"));
                innerHtml = (String)((JavascriptExecutor)driver).executeScript("return arguments[0].innerHTML;", new Object[]{body});
            } else {
                innerHtml = driver.getPageSource().replaceAll("&amp;", "&");
            }
            String string = innerHtml;
            return string;
        }
        catch (Exception e) {
            TemporaryFilesystem.getDefaultTmpFS().deleteTemporaryFiles();
            throw new RuntimeException(e);
        }
        finally {
            HtmlUnitWebDriver.cleanUpDriver(driver);
        }
    }

    private static void takeScreenshot(WebDriver driver, Configuration conf) {
        try {
            String url = driver.getCurrentUrl();
            File srcFile = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
            LOG.debug("In-memory screenshot taken of: {}", (Object)url);
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (conf.get("screenshot.location") != null) {
                Path screenshotPath = new Path(conf.get("screenshot.location") + "/" + srcFile.getName());
                FSDataOutputStream os = null;
                if (!fs.exists(screenshotPath)) {
                    LOG.debug("No existing screenshot already exists... creating new file at {} {}.", (Object)screenshotPath, (Object)srcFile.getName());
                    os = fs.create(screenshotPath);
                }
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(srcFile));
                IOUtils.copyBytes((InputStream)is, (OutputStream)os, (Configuration)conf);
                LOG.debug("Screenshot for {} successfully saved to: {} {}", new Object[]{url, screenshotPath, srcFile.getName()});
            } else {
                LOG.warn("Screenshot for {} not saved to HDFS (subsequently disgarded) as value for 'screenshot.location' is absent from nutch-site.xml.", (Object)url);
            }
        }
        catch (Exception e) {
            HtmlUnitWebDriver.cleanUpDriver(driver);
            throw new RuntimeException(e);
        }
    }
}

