/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.Inlink;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.crawl.LinkDbFilter;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkDbMerger
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public LinkDbMerger() {
    }

    public LinkDbMerger(Configuration conf) {
        this.setConf(conf);
    }

    public void merge(Path output, Path[] dbs, boolean normalize, boolean filter) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("LinkDb merge: starting");
        Job job = LinkDbMerger.createMergeJob(this.getConf(), output, normalize, filter);
        for (int i = 0; i < dbs.length; ++i) {
            FileInputFormat.addInputPath((Job)job, (Path)new Path(dbs[i], "current"));
        }
        try {
            boolean success = job.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage("LinkDbMerge", job);
                LOG.error(message);
                throw new RuntimeException(message);
            }
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error("LinkDbMerge job failed: {}", (Object)e.getMessage());
            throw e;
        }
        FileSystem fs = output.getFileSystem(this.getConf());
        fs.mkdirs(output);
        fs.rename(FileOutputFormat.getOutputPath((JobContext)job), new Path(output, "current"));
        stopWatch.stop();
        LOG.info("LinkDb merge: finished, elapsed: {} ms", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
    }

    public static Job createMergeJob(Configuration config, Path linkDb, boolean normalize, boolean filter) throws IOException {
        Path newLinkDb = new Path(linkDb, "merge-" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        Job job = Job.getInstance((Configuration)config, (String)("Nutch LinkDbMerger: " + String.valueOf(linkDb)));
        Configuration conf = job.getConfiguration();
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setMapperClass(LinkDbFilter.class);
        conf.setBoolean("linkdb.url.normalizer", normalize);
        conf.setBoolean("linkdb.url.filters", filter);
        job.setJarByClass(LinkDbMerger.class);
        job.setReducerClass(LinkDbMergeReducer.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)newLinkDb);
        job.setOutputFormatClass(MapFileOutputFormat.class);
        conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Inlinks.class);
        conf.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
        return job;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new LinkDbMerger(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: LinkDbMerger <output_linkdb> <linkdb1> [<linkdb2> <linkdb3> ...] [-normalize] [-filter]");
            System.err.println("\toutput_linkdb\toutput LinkDb");
            System.err.println("\tlinkdb1 ...\tinput LinkDb-s (single input LinkDb is ok)");
            System.err.println("\t-normalize\tuse URLNormalizer on both fromUrls and toUrls in linkdb(s) (usually not needed)");
            System.err.println("\t-filter\tuse URLFilters on both fromUrls and toUrls in linkdb(s)");
            return -1;
        }
        Path output = new Path(args[0]);
        ArrayList<Path> dbs = new ArrayList<Path>();
        boolean normalize = false;
        boolean filter = false;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-filter")) {
                filter = true;
                continue;
            }
            if (args[i].equals("-normalize")) {
                normalize = true;
                continue;
            }
            dbs.add(new Path(args[i]));
        }
        try {
            this.merge(output, dbs.toArray(new Path[dbs.size()]), normalize, filter);
            return 0;
        }
        catch (Exception e) {
            LOG.error("LinkDbMerger: {}", (Object)StringUtils.stringifyException((Throwable)e));
            return -1;
        }
    }

    public static class LinkDbMergeReducer
    extends Reducer<Text, Inlinks, Text, Inlinks> {
        private int maxInlinks;

        public void setup(Reducer.Context context) {
            Configuration conf = context.getConfiguration();
            this.maxInlinks = conf.getInt("linkdb.max.inlinks", 10000);
        }

        public void reduce(Text key, Iterable<Inlinks> values, Reducer.Context context) throws IOException, InterruptedException {
            Inlinks result = new Inlinks();
            for (Inlinks inlinks : values) {
                int end = Math.min(this.maxInlinks - result.size(), inlinks.size());
                Iterator<Inlink> it = inlinks.iterator();
                int i = 0;
                while (it.hasNext() && i++ < end) {
                    result.add(it.next());
                }
            }
            if (result.size() == 0) {
                return;
            }
            context.write((Object)key, (Object)result);
        }
    }
}

