/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class SnapshotsStatusResponse
extends ActionResponse
implements ToXContentObject {
    private final List<SnapshotStatus> snapshots;
    private static final ConstructingObjectParser<SnapshotsStatusResponse, Void> PARSER = new ConstructingObjectParser("snapshots_status_response", true, parsedObjects -> {
        List snapshots = (List)parsedObjects[0];
        return new SnapshotsStatusResponse(snapshots);
    });

    public SnapshotsStatusResponse(StreamInput in) throws IOException {
        super(in);
        this.snapshots = Collections.unmodifiableList(in.readList(SnapshotStatus::new));
    }

    SnapshotsStatusResponse(List<SnapshotStatus> snapshots) {
        this.snapshots = snapshots;
    }

    public List<SnapshotStatus> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.snapshots);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("snapshots");
        for (SnapshotStatus snapshot : this.snapshots) {
            snapshot.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SnapshotsStatusResponse fromXContent(XContentParser parser) throws IOException {
        return (SnapshotsStatusResponse)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.snapshots, ((SnapshotsStatusResponse)o).snapshots);
    }

    public int hashCode() {
        return this.snapshots != null ? this.snapshots.hashCode() : 0;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), SnapshotStatus.PARSER, new ParseField("snapshots", new String[0]));
    }
}

