/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.logging;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.opensearch.common.logging.OpenSearchLogMessage;

@Plugin(name="RateLimitingFilter", category="Core", elementType="filter")
public class RateLimitingFilter
extends AbstractFilter {
    private final Set<String> lruKeyCache = Collections.newSetFromMap(Collections.synchronizedMap(new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 128;
        }
    }));

    public RateLimitingFilter() {
        this(Filter.Result.ACCEPT, Filter.Result.DENY);
    }

    public RateLimitingFilter(Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
    }

    public void reset() {
        this.lruKeyCache.clear();
    }

    public Filter.Result filter(Message message) {
        if (message instanceof OpenSearchLogMessage) {
            OpenSearchLogMessage opensearchLogMessage = (OpenSearchLogMessage)message;
            String xOpaqueId = opensearchLogMessage.getValueFor("x-opaque-id");
            String key = opensearchLogMessage.getValueFor("key");
            return this.lruKeyCache.add(xOpaqueId + key) ? Filter.Result.ACCEPT : Filter.Result.DENY;
        }
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(LogEvent event) {
        return this.filter(event.getMessage());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter(msg);
    }

    @PluginFactory
    public static RateLimitingFilter createFilter(@PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch) {
        return new RateLimitingFilter(match, mismatch);
    }
}

