/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.search.fetch.subphase.FieldAndFormat;

public class FetchDocValuesContext {
    private final List<FieldAndFormat> fields;

    public static FetchDocValuesContext create(MapperService mapperService, List<FieldAndFormat> fieldPatterns) {
        ArrayList<FieldAndFormat> fields = new ArrayList<FieldAndFormat>();
        for (FieldAndFormat field : fieldPatterns) {
            Set<String> fieldNames = mapperService.simpleMatchToFullName(field.field);
            for (String fieldName : fieldNames) {
                fields.add(new FieldAndFormat(fieldName, field.format));
            }
        }
        int maxAllowedDocvalueFields = mapperService.getIndexSettings().getMaxDocvalueFields();
        if (fields.size() > maxAllowedDocvalueFields) {
            throw new IllegalArgumentException("Trying to retrieve too many docvalue_fields. Must be less than or equal to: [" + maxAllowedDocvalueFields + "] but was [" + fields.size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.getKey() + "] index level setting.");
        }
        return new FetchDocValuesContext(fields);
    }

    public FetchDocValuesContext(List<FieldAndFormat> fields) {
        this.fields = fields;
    }

    public List<FieldAndFormat> fields() {
        return this.fields;
    }
}

