/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.MinDocQuery;
import org.apache.lucene.queries.SearchAfterSortedDocQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.opensearch.action.search.SearchShardTask;
import org.opensearch.common.Booleans;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.common.util.concurrent.QueueResizingOpenSearchThreadPoolExecutor;
import org.opensearch.index.IndexSortConfig;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.SearchContextSourcePrinter;
import org.opensearch.search.SearchService;
import org.opensearch.search.aggregations.AggregationPhase;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.ScrollContext;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.profile.ProfileShardResult;
import org.opensearch.search.profile.SearchProfileShardResults;
import org.opensearch.search.profile.query.InternalProfileCollector;
import org.opensearch.search.query.EarlyTerminatingCollector;
import org.opensearch.search.query.QueryCollectorContext;
import org.opensearch.search.query.QueryPhaseExecutionException;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.TopDocsCollectorContext;
import org.opensearch.search.rescore.RescorePhase;
import org.opensearch.search.sort.SortAndFormats;
import org.opensearch.search.suggest.SuggestPhase;
import org.opensearch.tasks.TaskCancelledException;

public class QueryPhase {
    private static final Logger LOGGER = LogManager.getLogger(QueryPhase.class);
    public static final boolean SYS_PROP_REWRITE_SORT = Booleans.parseBoolean((String)System.getProperty("opensearch.search.rewrite_sort", "true"));
    private final AggregationPhase aggregationPhase = new AggregationPhase();
    private final SuggestPhase suggestPhase = new SuggestPhase();
    private final RescorePhase rescorePhase = new RescorePhase();

    public void preProcess(SearchContext context) {
        Runnable cancellation = context.lowLevelCancellation() ? context.searcher().addQueryCancellation(() -> {
            SearchShardTask task = context.getTask();
            if (task != null && task.isCancelled()) {
                throw new TaskCancelledException("cancelled task with reason: " + task.getReasonCancelled());
            }
        }) : null;
        try {
            context.preProcess(true);
        }
        finally {
            if (cancellation != null) {
                context.searcher().removeQueryCancellation(cancellation);
            }
        }
    }

    public void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        if (searchContext.hasOnlySuggest()) {
            this.suggestPhase.execute(searchContext);
            searchContext.queryResult().topDocs(new TopDocsAndMaxScore(new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN), new DocValueFormat[0]);
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchContextSourcePrinter(searchContext));
        }
        this.aggregationPhase.preProcess(searchContext);
        boolean rescore = QueryPhase.executeInternal(searchContext);
        if (rescore) {
            this.rescorePhase.execute(searchContext);
        }
        this.suggestPhase.execute(searchContext);
        this.aggregationPhase.execute(searchContext);
        if (searchContext.getProfilers() != null) {
            ProfileShardResult shardResults = SearchProfileShardResults.buildShardResults(searchContext.getProfilers());
            searchContext.queryResult().profileResults(shardResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean executeInternal(SearchContext searchContext) throws QueryPhaseExecutionException {
        Runnable timeoutRunnable;
        boolean timeoutSet;
        ContextIndexSearcher searcher = searchContext.searcher();
        IndexReader reader = searcher.getIndexReader();
        QuerySearchResult queryResult = searchContext.queryResult();
        queryResult.searchTimedOut(false);
        queryResult.from(searchContext.from());
        queryResult.size(searchContext.size());
        Query query = searchContext.query();
        assert (query == searcher.rewrite(query));
        ScrollContext scrollContext = searchContext.scrollContext();
        if (scrollContext != null) {
            if (scrollContext.totalHits == null) {
                assert (scrollContext.lastEmittedDoc == null);
            } else {
                ScoreDoc after = scrollContext.lastEmittedDoc;
                if (QueryPhase.returnsDocsInOrder(query, searchContext.sort())) {
                    if (after != null) {
                        query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new MinDocQuery(after.doc + 1), BooleanClause.Occur.FILTER).build();
                    }
                    searchContext.terminateAfter(searchContext.size());
                } else if (QueryPhase.canEarlyTerminate(reader, searchContext.sort()) && after != null) {
                    query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new SearchAfterSortedDocQuery(searchContext.sort().sort, (FieldDoc)after), BooleanClause.Occur.FILTER).build();
                }
            }
        }
        LinkedList<QueryCollectorContext> collectors = new LinkedList<QueryCollectorContext>();
        boolean hasFilterCollector = false;
        if (searchContext.terminateAfter() != 0) {
            collectors.add(QueryCollectorContext.createEarlyTerminationCollectorContext(searchContext.terminateAfter()));
            hasFilterCollector = true;
        }
        if (searchContext.parsedPostFilter() != null) {
            collectors.add(QueryCollectorContext.createFilteredCollectorContext(searcher, searchContext.parsedPostFilter().query()));
            hasFilterCollector = true;
        }
        if (!searchContext.queryCollectors().isEmpty()) {
            collectors.add(QueryCollectorContext.createMultiCollectorContext(searchContext.queryCollectors().values()));
        }
        if (searchContext.minimumScore() != null) {
            collectors.add(QueryCollectorContext.createMinScoreCollectorContext(searchContext.minimumScore().floatValue()));
            hasFilterCollector = true;
        }
        if (searchContext.sort() != null && SYS_PROP_REWRITE_SORT) {
            QueryPhase.enhanceSortOnNumeric(searchContext, searcher.getIndexReader());
        }
        boolean bl = timeoutSet = scrollContext == null && searchContext.timeout() != null && !searchContext.timeout().equals((Object)SearchService.NO_TIMEOUT);
        if (timeoutSet) {
            long startTime = searchContext.getRelativeTimeInMillis();
            long timeout = searchContext.timeout().millis();
            long maxTime = startTime + timeout;
            timeoutRunnable = searcher.addQueryCancellation(() -> {
                long time = searchContext.getRelativeTimeInMillis();
                if (time > maxTime) {
                    throw new TimeExceededException();
                }
            });
        } else {
            timeoutRunnable = null;
        }
        if (searchContext.lowLevelCancellation()) {
            searcher.addQueryCancellation(() -> {
                SearchShardTask task = searchContext.getTask();
                if (task != null && task.isCancelled()) {
                    throw new TaskCancelledException("cancelled task with reason: " + task.getReasonCancelled());
                }
            });
        }
        try {
            boolean shouldRescore = QueryPhase.searchWithCollector(searchContext, searcher, query, collectors, hasFilterCollector, timeoutSet);
            ExecutorService executor = searchContext.indexShard().getThreadPool().executor("search");
            if (executor instanceof QueueResizingOpenSearchThreadPoolExecutor) {
                QueueResizingOpenSearchThreadPoolExecutor rExecutor = (QueueResizingOpenSearchThreadPoolExecutor)executor;
                queryResult.nodeQueueSize(rExecutor.getCurrentQueueSize());
                queryResult.serviceTimeEWMA((long)rExecutor.getTaskExecutionEWMA());
            }
            boolean bl2 = shouldRescore;
            if (timeoutRunnable != null) {
                searcher.removeQueryCancellation(timeoutRunnable);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            try {
                if (timeoutRunnable != null) {
                    searcher.removeQueryCancellation(timeoutRunnable);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Failed to execute main query", e);
            }
        }
    }

    private static boolean searchWithCollector(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean timeoutSet) throws IOException {
        Collector queryCollector;
        TopDocsCollectorContext topDocsFactory = TopDocsCollectorContext.createTopDocsCollectorContext(searchContext, hasFilterCollector);
        collectors.addFirst(topDocsFactory);
        if (searchContext.getProfilers() != null) {
            InternalProfileCollector profileCollector = QueryCollectorContext.createQueryCollectorWithProfiler(collectors);
            searchContext.getProfilers().getCurrentQueryProfiler().setCollector(profileCollector);
            queryCollector = profileCollector;
        } else {
            queryCollector = QueryCollectorContext.createQueryCollector(collectors);
        }
        QuerySearchResult queryResult = searchContext.queryResult();
        try {
            searcher.search(query, queryCollector);
        }
        catch (EarlyTerminatingCollector.EarlyTerminationException e) {
            queryResult.terminatedEarly(true);
        }
        catch (TimeExceededException e) {
            assert (timeoutSet) : "TimeExceededException thrown even though timeout wasn't set";
            if (!searchContext.request().allowPartialSearchResults()) {
                throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Time exceeded");
            }
            queryResult.searchTimedOut(true);
        }
        if (searchContext.terminateAfter() != 0 && queryResult.terminatedEarly() == null) {
            queryResult.terminatedEarly(false);
        }
        for (QueryCollectorContext ctx : collectors) {
            ctx.postProcess(queryResult);
        }
        return topDocsFactory.shouldRescore();
    }

    private static void enhanceSortOnNumeric(SearchContext searchContext, IndexReader reader) {
        if (QueryPhase.canEarlyTerminate(reader, searchContext.sort())) {
            return;
        }
        Sort sort = searchContext.sort().sort;
        SortField sortField = sort.getSort()[0];
        if (!SortField.Type.LONG.equals((Object)IndexSortConfig.getSortFieldType(sortField))) {
            return;
        }
        String fieldName = sortField.getField();
        if (fieldName == null) {
            return;
        }
        if (searchContext.mapperService() == null) {
            return;
        }
        MappedFieldType fieldType = searchContext.mapperService().fieldType(fieldName);
        if (fieldType == null) {
            return;
        }
        if (!fieldType.typeName().equals("long") && !(fieldType instanceof DateFieldMapper.DateFieldType)) {
            return;
        }
        if (!fieldType.isSearchable()) {
            return;
        }
        if (!fieldType.hasDocValues()) {
            return;
        }
        sortField.setCanUsePoints();
    }

    private static boolean returnsDocsInOrder(Query query, SortAndFormats sf) {
        if (sf == null || Sort.RELEVANCE.equals((Object)sf.sort)) {
            return query.getClass() == ConstantScoreQuery.class || query.getClass() == MatchAllDocsQuery.class;
        }
        return Sort.INDEXORDER.equals((Object)sf.sort);
    }

    private static boolean canEarlyTerminate(IndexReader reader, SortAndFormats sortAndFormats) {
        if (sortAndFormats == null || sortAndFormats.sort == null) {
            return false;
        }
        Sort sort = sortAndFormats.sort;
        for (LeafReaderContext ctx : reader.leaves()) {
            Sort indexSort = ctx.reader().getMetaData().getSort();
            if (indexSort != null && Lucene.canEarlyTerminate(sort, indexSort)) continue;
            return false;
        }
        return true;
    }

    private static class TimeExceededException
    extends RuntimeException {
        private TimeExceededException() {
        }
    }
}

