/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.httpclient;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.protocol.httpclient.HttpAuthentication;
import org.apache.nutch.protocol.httpclient.HttpBasicAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAuthenticationFactory
implements Configurable {
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Configuration conf = null;

    public HttpAuthenticationFactory(Configuration conf) {
        this.setConf(conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public HttpAuthentication findAuthentication(Metadata header) {
        if (header == null) {
            return null;
        }
        try {
            ArrayList<String> challenge = new ArrayList<String>();
            challenge.add(header.get(WWW_AUTHENTICATE));
            for (String challengeString : challenge) {
                HttpBasicAuthentication auth;
                if (challengeString.equals("NTLM")) {
                    challengeString = "Basic realm=techweb";
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Checking challengeString=" + challengeString);
                }
                if ((auth = HttpBasicAuthentication.getAuthentication(challengeString, this.conf)) == null) continue;
                return auth;
            }
        }
        catch (Exception e) {
            LOG.error("Error: ", (Throwable)e);
        }
        return null;
    }
}

