/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;

public interface SpanQueryBuilder
extends QueryBuilder {

    public static class SpanQueryBuilderUtil {
        private SpanQueryBuilderUtil() {
        }

        static void checkNoBoost(String queryName, String fieldName, XContentParser parser, SpanQueryBuilder clause) {
            try {
                if (clause.boost() != 1.0f) {
                    throw new ParsingException(parser.getTokenLocation(), queryName + " [" + fieldName + "] as a nested span clause can't have non-default boost value [" + clause.boost() + "]", new Object[0]);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

