/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.servicedocument.ServiceDocument;
import org.apache.olingo.odata2.core.ep.ContentTypeBasedEntityProvider;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.consumer.JsonEntityConsumer;
import org.apache.olingo.odata2.core.ep.consumer.JsonErrorDocumentConsumer;
import org.apache.olingo.odata2.core.ep.consumer.JsonServiceDocumentConsumer;
import org.apache.olingo.odata2.core.ep.producer.JsonCollectionEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonErrorDocumentProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonFeedEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonLinkEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonLinksEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonPropertyEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonServiceDocumentProducer;
import org.apache.olingo.odata2.core.ep.util.CircleStreamBuffer;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class JsonEntityProvider
implements ContentTypeBasedEntityProvider {
    private static final String DEFAULT_CHARSET = "UTF-8";

    @Override
    public ODataResponse writeErrorDocument(HttpStatusCodes status, String errorCode, String message, Locale locale, String innerError) {
        ODataErrorContext context = new ODataErrorContext();
        context.setHttpStatus(status);
        context.setErrorCode(errorCode);
        context.setMessage(message);
        context.setLocale(locale);
        context.setInnerError(innerError);
        return this.writeErrorDocument(context);
    }

    @Override
    public ODataResponse writeErrorDocument(ODataErrorContext context) {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(buffer.getOutputStream(), DEFAULT_CHARSET));
            new JsonErrorDocumentProducer().writeErrorDocument(writer, context);
            writer.flush();
            buffer.closeWrite();
            return ODataResponse.status((HttpStatusCodes)context.getHttpStatus()).entity((Object)buffer.getInputStream()).header("DataServiceVersion", "1.0").build();
        }
        catch (Exception e) {
            buffer.close();
            throw new ODataRuntimeException(e);
        }
    }

    @Override
    public ODataResponse writeServiceDocument(Edm edm, String serviceRoot) throws EntityProviderException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(buffer.getOutputStream(), DEFAULT_CHARSET));
            JsonServiceDocumentProducer.writeServiceDocument(writer, edm);
            writer.flush();
            buffer.closeWrite();
            return ODataResponse.entity((Object)buffer.getInputStream()).header("DataServiceVersion", "1.0").build();
        }
        catch (Exception e) {
            buffer.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }

    @Override
    public ODataResponse writeEntry(EdmEntitySet entitySet, Map<String, Object> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        EntityInfoAggregator entityInfo = EntityInfoAggregator.create(entitySet, properties.getExpandSelectTree());
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(buffer.getOutputStream(), DEFAULT_CHARSET));
            JsonEntryEntityProducer producer = new JsonEntryEntityProducer(properties);
            producer.append(writer, entityInfo, data, true);
            writer.flush();
            buffer.closeWrite();
            return ODataResponse.entity((Object)buffer.getInputStream()).eTag(producer.getETag()).idLiteral(producer.getLocation()).build();
        }
        catch (EntityProviderException e) {
            buffer.close();
            throw e;
        }
        catch (Exception e) {
            buffer.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }

    @Override
    public ODataResponse writeProperty(EdmProperty edmProperty, Object value) throws EntityProviderException {
        return this.writeSingleTypedElement(EntityInfoAggregator.create(edmProperty), value);
    }

    private ODataResponse writeSingleTypedElement(EntityPropertyInfo propertyInfo, Object value) throws EntityProviderException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            OutputStream outStream = buffer.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outStream, DEFAULT_CHARSET));
            new JsonPropertyEntityProducer().append(writer, propertyInfo, value);
            writer.flush();
            buffer.closeWrite();
            return ODataResponse.entity((Object)buffer.getInputStream()).header("DataServiceVersion", "1.0").build();
        }
        catch (EntityProviderException e) {
            buffer.close();
            throw e;
        }
        catch (Exception e) {
            buffer.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }

    @Override
    public ODataResponse writeFeed(EdmEntitySet entitySet, List<Map<String, Object>> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        EntityInfoAggregator entityInfo = EntityInfoAggregator.create(entitySet, properties.getExpandSelectTree());
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(buffer.getOutputStream(), DEFAULT_CHARSET));
            new JsonFeedEntityProducer(properties).appendAsObject(writer, entityInfo, data, true);
            writer.flush();
            buffer.closeWrite();
            return ODataResponse.entity((Object)buffer.getInputStream()).build();
        }
        catch (EntityProviderException e) {
            buffer.close();
            throw e;
        }
        catch (Exception e) {
            buffer.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }

    @Override
    public ODataResponse writeLink(EdmEntitySet entitySet, Map<String, Object> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        EntityInfoAggregator entityInfo = EntityInfoAggregator.create(entitySet, properties.getExpandSelectTree());
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(buffer.getOutputStream(), DEFAULT_CHARSET));
            new JsonLinkEntityProducer(properties).append(writer, entityInfo, data);
            writer.flush();
            buffer.closeWrite();
            return ODataResponse.entity((Object)buffer.getInputStream()).header("DataServiceVersion", "1.0").build();
        }
        catch (EntityProviderException e) {
            buffer.close();
            throw e;
        }
        catch (Exception e) {
            buffer.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }

    @Override
    public ODataResponse writeLinks(EdmEntitySet entitySet, List<Map<String, Object>> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        EntityInfoAggregator entityInfo = EntityInfoAggregator.create(entitySet, properties.getExpandSelectTree());
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(buffer.getOutputStream(), DEFAULT_CHARSET));
            new JsonLinksEntityProducer(properties).append(writer, entityInfo, data);
            writer.flush();
            buffer.closeWrite();
            ODataResponse.ODataResponseBuilder response = ODataResponse.entity((Object)buffer.getInputStream());
            if (properties.getInlineCountType() != InlineCount.ALLPAGES) {
                response = response.header("DataServiceVersion", "1.0");
            }
            return response.build();
        }
        catch (EntityProviderException e) {
            buffer.close();
            throw e;
        }
        catch (Exception e) {
            buffer.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }

    private ODataResponse writeCollection(EntityPropertyInfo propertyInfo, List<?> data) throws EntityProviderException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(buffer.getOutputStream(), DEFAULT_CHARSET));
            new JsonCollectionEntityProducer().append(writer, propertyInfo, data);
            writer.flush();
            buffer.closeWrite();
            return ODataResponse.entity((Object)buffer.getInputStream()).build();
        }
        catch (EntityProviderException e) {
            buffer.close();
            throw e;
        }
        catch (Exception e) {
            buffer.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }

    @Override
    public ODataResponse writeFunctionImport(EdmFunctionImport functionImport, Object data, EntityProviderWriteProperties properties) throws EntityProviderException {
        try {
            if (functionImport.getReturnType() != null) {
                boolean isCollection;
                boolean bl = isCollection = functionImport.getReturnType().getMultiplicity() == EdmMultiplicity.MANY;
                if (functionImport.getReturnType().getType().getKind() == EdmTypeKind.ENTITY) {
                    if (isCollection) {
                        List dataList = (List)data;
                        return this.writeFeed(functionImport.getEntitySet(), dataList, properties);
                    }
                    return this.writeEntry(functionImport.getEntitySet(), (Map)data, properties);
                }
                EntityPropertyInfo info = EntityInfoAggregator.create(functionImport);
                if (isCollection) {
                    return this.writeCollection(info, (List)data);
                }
                return this.writeSingleTypedElement(info, data);
            }
            return ODataResponse.newBuilder().status(HttpStatusCodes.ACCEPTED).build();
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), e);
        }
    }

    @Override
    public ODataFeed readFeed(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return new JsonEntityConsumer().readFeed(entitySet, content, properties);
    }

    @Override
    public ODataEntry readEntry(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return new JsonEntityConsumer().readEntry(entitySet, content, properties);
    }

    @Override
    public Map<String, Object> readProperty(EdmProperty edmProperty, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return new JsonEntityConsumer().readProperty(edmProperty, content, properties);
    }

    @Override
    public Object readFunctionImport(EdmFunctionImport functionImport, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        try {
            if (functionImport.getReturnType().getType().getKind() == EdmTypeKind.ENTITY) {
                return functionImport.getReturnType().getMultiplicity() == EdmMultiplicity.MANY ? new JsonEntityConsumer().readFeed(functionImport.getEntitySet(), content, properties) : new JsonEntityConsumer().readEntry(functionImport.getEntitySet(), content, properties);
            }
            EntityPropertyInfo info = EntityInfoAggregator.create(functionImport);
            return functionImport.getReturnType().getMultiplicity() == EdmMultiplicity.MANY ? new JsonEntityConsumer().readCollection(info, content, properties) : new JsonEntityConsumer().readProperty(info, content, properties).get(info.getName());
        }
        catch (EdmException e) {
            throw new EntityProviderException(e.getMessageReference(), (Throwable)e);
        }
    }

    @Override
    public String readLink(EdmEntitySet entitySet, InputStream content) throws EntityProviderException {
        return new JsonEntityConsumer().readLink(entitySet, content);
    }

    @Override
    public List<String> readLinks(EdmEntitySet entitySet, InputStream content) throws EntityProviderException {
        return new JsonEntityConsumer().readLinks(entitySet, content);
    }

    @Override
    public ServiceDocument readServiceDocument(InputStream serviceDocument) throws EntityProviderException {
        return new JsonServiceDocumentConsumer().parseJson(serviceDocument);
    }

    @Override
    public ODataDeltaFeed readDeltaFeed(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return new JsonEntityConsumer().readDeltaFeed(entitySet, content, properties);
    }

    @Override
    public ODataErrorContext readErrorDocument(InputStream errorDocument) throws EntityProviderException {
        return new JsonErrorDocumentConsumer().readError(errorDocument);
    }
}

