/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.io.Serializable;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

final class DefaultHttpStatusCode
implements HttpStatusCode,
Comparable<HttpStatusCode>,
Serializable {
    private static final long serialVersionUID = 7017664779360718111L;
    private final int value;

    public DefaultHttpStatusCode(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public boolean is1xxInformational() {
        return this.hundreds() == 1;
    }

    @Override
    public boolean is2xxSuccessful() {
        return this.hundreds() == 2;
    }

    @Override
    public boolean is3xxRedirection() {
        return this.hundreds() == 3;
    }

    @Override
    public boolean is4xxClientError() {
        return this.hundreds() == 4;
    }

    @Override
    public boolean is5xxServerError() {
        return this.hundreds() == 5;
    }

    @Override
    public boolean isError() {
        int hundreds = this.hundreds();
        return hundreds == 4 || hundreds == 5;
    }

    private int hundreds() {
        return this.value / 100;
    }

    @Override
    public int compareTo(@NonNull HttpStatusCode o) {
        return Integer.compare(this.value, o.value());
    }

    public boolean equals(@Nullable Object other) {
        HttpStatusCode that;
        return this == other || other instanceof HttpStatusCode && this.value == (that = (HttpStatusCode)other).value();
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

