/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.http;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.olingo.client.api.http.HttpClientFactory;
import org.apache.olingo.client.api.http.WrappingHttpClientFactory;
import org.apache.olingo.client.core.http.AbstractHttpClientFactory;
import org.apache.olingo.client.core.http.DefaultHttpClientFactory;
import org.apache.olingo.client.core.http.OAuth2Exception;
import org.apache.olingo.commons.api.http.HttpMethod;

public abstract class AbstractOAuth2HttpClientFactory
extends AbstractHttpClientFactory
implements WrappingHttpClientFactory {
    protected final DefaultHttpClientFactory wrapped;
    protected final URI oauth2GrantServiceURI;
    protected final URI oauth2TokenServiceURI;
    protected HttpUriRequest currentRequest;

    public AbstractOAuth2HttpClientFactory(URI oauth2GrantServiceURI, URI oauth2TokenServiceURI) {
        this(new DefaultHttpClientFactory(), oauth2GrantServiceURI, oauth2TokenServiceURI);
    }

    public AbstractOAuth2HttpClientFactory(DefaultHttpClientFactory wrapped, URI oauth2GrantServiceURI, URI oauth2TokenServiceURI) {
        this.wrapped = wrapped;
        this.oauth2GrantServiceURI = oauth2GrantServiceURI;
        this.oauth2TokenServiceURI = oauth2TokenServiceURI;
    }

    public HttpClientFactory getWrappedHttpClientFactory() {
        return this.wrapped;
    }

    protected abstract boolean isInited() throws OAuth2Exception;

    protected abstract void init() throws OAuth2Exception;

    protected abstract void accessToken(DefaultHttpClient var1) throws OAuth2Exception;

    protected abstract void refreshToken(DefaultHttpClient var1) throws OAuth2Exception;

    public HttpClient create(HttpMethod method, URI uri) {
        if (!this.isInited()) {
            this.init();
        }
        final DefaultHttpClient httpClient = this.wrapped.create(method, uri);
        this.accessToken(httpClient);
        httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                AbstractOAuth2HttpClientFactory.this.currentRequest = request instanceof HttpUriRequest ? (HttpUriRequest)request : null;
            }
        });
        httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (response.getStatusLine().getStatusCode() == 401) {
                    AbstractOAuth2HttpClientFactory.this.refreshToken(httpClient);
                    if (AbstractOAuth2HttpClientFactory.this.currentRequest != null) {
                        httpClient.execute(AbstractOAuth2HttpClientFactory.this.currentRequest);
                    }
                }
            }
        });
        return httpClient;
    }

    public void close(HttpClient httpClient) {
        this.wrapped.close(httpClient);
    }
}

