/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.communication.request.invoke.ClientNoContent;
import org.apache.olingo.client.api.communication.response.ODataInvokeResponse;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.domain.ClientInvokeResult;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.client.api.uri.URIFilter;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.ComplexCollection;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.OperationType;
import org.apache.olingo.ext.proxy.api.Operations;
import org.apache.olingo.ext.proxy.api.PrimitiveCollection;
import org.apache.olingo.ext.proxy.api.Sort;
import org.apache.olingo.ext.proxy.api.annotations.Operation;
import org.apache.olingo.ext.proxy.commons.AbstractInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.OperationInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PrimitiveCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;
import org.apache.olingo.ext.proxy.utils.CoreUtils;
import org.apache.olingo.ext.proxy.utils.ProxyUtils;

public class InvokerInvocationHandler<T, O extends Operations>
extends AbstractInvocationHandler {
    private final URI baseURI;
    private URIBuilder uri;
    private final Map<String, ClientValue> parameters;
    private final Operation operation;
    private final EdmOperation edmOperation;
    protected final Class<T> targetRef;
    private final Class<?> operationRef;

    public InvokerInvocationHandler(URI uri, Map<String, ClientValue> parameters, Operation operation, EdmOperation edmOperation, Type[] references, AbstractService<?> service) {
        super(service);
        this.baseURI = uri;
        this.uri = this.baseURI == null ? null : service.getClient().newURIBuilder(this.baseURI.toASCIIString());
        this.parameters = parameters;
        this.operation = operation;
        this.edmOperation = edmOperation;
        if (references.length > 0) {
            this.targetRef = ClassUtils.getTypeClass(references[0]);
            this.operationRef = references.length > 1 ? ClassUtils.getTypeClass(references[1]) : null;
        } else {
            this.targetRef = null;
            this.operationRef = null;
        }
    }

    public Future<T> executeAsync() {
        return this.service.getClient().getConfiguration().getExecutor().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return InvokerInvocationHandler.this.execute();
            }
        });
    }

    public T execute() {
        if (this.operation == null || this.uri == null) {
            throw new IllegalStateException("Invalid operation");
        }
        try {
            Object res;
            if (this.operation.type() == OperationType.ACTION) {
                this.service.getPersistenceManager().flush();
            }
            ClientInvokeResult result = ((ODataInvokeResponse)this.service.getClient().getInvokeRequestFactory().getInvokeRequest(this.edmOperation instanceof EdmFunction ? HttpMethod.GET : HttpMethod.POST, this.uri.build(), this.getResultReference(this.edmOperation.getReturnType()), this.parameters).execute()).getBody();
            if (StringUtils.isBlank((CharSequence)this.operation.returnType())) {
                return (T)ClassUtils.returnVoid();
            }
            EdmTypeInfo returnType = new EdmTypeInfo.Builder().setEdm(this.service.getClient().getCachedEdm()).setTypeExpression(this.operation.returnType()).build();
            if (returnType.isEntityType()) {
                if (returnType.isCollection()) {
                    Class<?> collItemType = ClassUtils.extractTypeArg(this.targetRef, EntityCollection.class);
                    return (T)ProxyUtils.getEntityCollectionProxy(this.service, collItemType, this.targetRef, null, (ClientEntitySet)result, this.baseURI, false);
                }
                return (T)ProxyUtils.getEntityProxy(this.service, (ClientEntity)result, null, this.targetRef, null, false);
            }
            Class ref = ClassUtils.getTypeClass(this.targetRef);
            ClientProperty property = (ClientProperty)result;
            if (property == null || property.hasNullValue()) {
                res = null;
            } else if (returnType.isCollection()) {
                if (returnType.isComplexType()) {
                    Class<?> itemRef = ClassUtils.extractTypeArg(ref, ComplexCollection.class);
                    ArrayList<Object> items = new ArrayList<Object>();
                    for (ClientValue item : property.getValue().asCollection()) {
                        items.add(ProxyUtils.getComplexProxy(this.service, property.getName(), item, itemRef, null, null, true));
                    }
                    res = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ref}, new ComplexCollectionInvocationHandler(this.service, items, itemRef, null));
                } else {
                    ArrayList<Object> items = new ArrayList<Object>();
                    for (ClientValue item : property.getValue().asCollection()) {
                        items.add(item.asPrimitive().toValue());
                    }
                    res = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{PrimitiveCollection.class}, new PrimitiveCollectionInvocationHandler(this.service, items, null, null));
                }
            } else {
                res = returnType.isComplexType() ? ProxyUtils.getComplexProxy(this.service, property.getName(), (ClientValue)property.getValue().asComplex(), ref, null, null, false) : CoreUtils.getObjectFromODataValue(property.getValue(), this.targetRef, this.service);
            }
            return (T)res;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private <RES extends ClientInvokeResult> Class<RES> getResultReference(EdmReturnType returnType) {
        Class result = returnType == null ? ClientNoContent.class : (returnType.isCollection() && returnType.getType().getKind() == EdmTypeKind.ENTITY ? ClientEntitySet.class : (!returnType.isCollection() && returnType.getType().getKind() == EdmTypeKind.ENTITY ? ClientEntity.class : ClientProperty.class));
        return result;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("filter".equals(method.getName()) || "orderBy".equals(method.getName()) || "top".equals(method.getName()) || "skip".equals(method.getName()) || "expand".equals(method.getName()) || "select".equals(method.getName())) {
            this.invokeSelfMethod(method, args);
            return proxy;
        }
        if ("operations".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            EdmTypeInfo returnType = new EdmTypeInfo.Builder().setEdm(this.service.getClient().getCachedEdm()).setTypeExpression(this.operation.returnType()).build();
            URI prefixURI = URIUtils.buildFunctionInvokeURI((URI)this.baseURI, this.parameters);
            OperationInvocationHandler handler = returnType.isComplexType() ? (returnType.isCollection() ? OperationInvocationHandler.getInstance(new ComplexCollectionInvocationHandler<T>(this.targetRef, this.service, this.getClient().newURIBuilder(prefixURI.toASCIIString()))) : OperationInvocationHandler.getInstance(ComplexInvocationHandler.getInstance(this.targetRef, this.service, this.getClient().newURIBuilder(prefixURI.toASCIIString())))) : (returnType.isCollection() ? OperationInvocationHandler.getInstance(new EntityCollectionInvocationHandler(this.service, null, this.targetRef, null, this.getClient().newURIBuilder(prefixURI.toASCIIString()))) : OperationInvocationHandler.getInstance(EntityInvocationHandler.getInstance(prefixURI, this.targetRef, this.service)));
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.operationRef}, (InvocationHandler)handler);
        }
        if (this.isSelfMethod(method)) {
            return this.invokeSelfMethod(method, args);
        }
        throw new NoSuchMethodException(method.getName());
    }

    public void filter(String filter) {
        if (this.uri != null) {
            this.uri.filter(filter);
        }
    }

    public void filter(URIFilter filter) {
        if (this.uri != null) {
            this.uri.filter(filter);
        }
    }

    public void orderBy(Sort ... sort) {
        if (this.uri != null) {
            StringBuilder builder = new StringBuilder();
            for (Sort sortClause : sort) {
                builder.append(sortClause.getKey()).append(' ').append((Object)sortClause.getValue()).append(',');
            }
            builder.deleteCharAt(builder.length() - 1);
            this.uri.orderBy(builder.toString());
        }
    }

    public void orderBy(String orderBy) {
        if (this.uri != null) {
            this.uri.orderBy(orderBy);
        }
    }

    public void top(int top) throws IllegalArgumentException {
        if (this.uri != null) {
            this.uri.top(top);
        }
    }

    public void skip(int skip) throws IllegalArgumentException {
        if (this.uri != null) {
            this.uri.skip(skip);
        }
    }

    public void expand(String ... expand) {
        if (this.uri != null) {
            this.uri.expand(expand);
        }
    }

    public void select(String ... select) {
        if (this.uri != null) {
            this.uri.select(select);
        }
    }

    public void clearQueryOptions() {
        this.uri = this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString());
    }
}

