/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;
import org.apache.derby.shared.common.util.ArrayUtil;

public class InsertConstantAction
extends WriteCursorConstantAction {
    boolean[] indexedCols;
    private String schemaName;
    private String tableName;
    private String[] columnNames;
    RowLocation[] autoincRowLocation;
    private long[] autoincIncrement;
    private transient int firstAutoGenColumn = -1;
    public final boolean hasDeferrableChecks;
    String identitySequenceUUIDString;

    public InsertConstantAction() {
        this.hasDeferrableChecks = false;
    }

    InsertConstantAction(TableDescriptor tableDescriptor, long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, String[] stringArray, boolean bl, boolean bl2, Properties properties, UUID uUID, int n, FKInfo[] fKInfoArray, TriggerInfo triggerInfo, int[] nArray, boolean[] blArray, boolean bl3, RowLocation[] rowLocationArray, boolean bl4, String string) {
        super(l, staticCompiledOpenConglomInfo, indexRowGeneratorArray, lArray, staticCompiledOpenConglomInfoArray, stringArray, bl, properties, uUID, n, fKInfoArray, triggerInfo, null, null, nArray, bl3, bl4);
        this.indexedCols = blArray;
        this.autoincRowLocation = rowLocationArray;
        this.schemaName = tableDescriptor.getSchemaName();
        this.tableName = tableDescriptor.getName();
        this.columnNames = tableDescriptor.getColumnNamesArray();
        this.autoincIncrement = tableDescriptor.getAutoincIncrementArray();
        this.indexNames = stringArray;
        this.hasDeferrableChecks = bl2;
        this.identitySequenceUUIDString = string;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        Object[] objectArray = null;
        super.readExternal(objectInput);
        this.indexedCols = ArrayUtil.readBooleanArray((ObjectInput)objectInput);
        objectArray = ArrayUtil.readObjectArray((ObjectInput)objectInput);
        if (objectArray != null) {
            this.autoincRowLocation = new RowLocation[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.autoincRowLocation[n] = (RowLocation)objectArray[n];
            }
        }
        this.schemaName = (String)objectInput.readObject();
        this.tableName = (String)objectInput.readObject();
        objectArray = ArrayUtil.readObjectArray((ObjectInput)objectInput);
        if (objectArray != null) {
            this.columnNames = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.columnNames[n] = (String)objectArray[n];
            }
        }
        this.autoincIncrement = ArrayUtil.readLongArray((ObjectInput)objectInput);
        this.identitySequenceUUIDString = (String)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ArrayUtil.writeBooleanArray((ObjectOutput)objectOutput, (boolean[])this.indexedCols);
        ArrayUtil.writeArray((ObjectOutput)objectOutput, (Object[])this.autoincRowLocation);
        objectOutput.writeObject(this.schemaName);
        objectOutput.writeObject(this.tableName);
        ArrayUtil.writeArray((ObjectOutput)objectOutput, (Object[])this.columnNames);
        ArrayUtil.writeLongArray((ObjectOutput)objectOutput, (long[])this.autoincIncrement);
        objectOutput.writeObject(this.identitySequenceUUIDString);
    }

    public int getAutoGenColumn() {
        if (!this.hasAutoincrement()) {
            return -1;
        }
        if (this.firstAutoGenColumn < 0) {
            for (int i = 0; i < this.autoincIncrement.length; ++i) {
                if (this.autoincIncrement[i] <= 0L) continue;
                this.firstAutoGenColumn = i;
                break;
            }
        }
        return this.firstAutoGenColumn;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    String[] getColumnNames() {
        return this.columnNames;
    }

    public long getAutoincIncrement(int n) {
        return this.autoincIncrement[n];
    }

    public boolean hasAutoincrement() {
        return this.autoincRowLocation != null;
    }

    RowLocation[] getAutoincRowLocation() {
        return this.autoincRowLocation;
    }

    @Override
    public int getTypeFormatId() {
        return 38;
    }
}

