/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataMaximumValue is the corresponding interface of BACnetConstructedDataMaximumValue
type BACnetConstructedDataMaximumValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetMaximumValue returns MaximumValue (property field)
	GetMaximumValue() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataMaximumValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataMaximumValue()
	// CreateBuilder creates a BACnetConstructedDataMaximumValueBuilder
	CreateBACnetConstructedDataMaximumValueBuilder() BACnetConstructedDataMaximumValueBuilder
}

// _BACnetConstructedDataMaximumValue is the data-structure of this message
type _BACnetConstructedDataMaximumValue struct {
	BACnetConstructedDataContract
	MaximumValue BACnetApplicationTagReal
}

var _ BACnetConstructedDataMaximumValue = (*_BACnetConstructedDataMaximumValue)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataMaximumValue)(nil)

// NewBACnetConstructedDataMaximumValue factory function for _BACnetConstructedDataMaximumValue
func NewBACnetConstructedDataMaximumValue(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, maximumValue BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataMaximumValue {
	if maximumValue == nil {
		panic("maximumValue of type BACnetApplicationTagReal for BACnetConstructedDataMaximumValue must not be nil")
	}
	_result := &_BACnetConstructedDataMaximumValue{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		MaximumValue:                  maximumValue,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataMaximumValueBuilder is a builder for BACnetConstructedDataMaximumValue
type BACnetConstructedDataMaximumValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(maximumValue BACnetApplicationTagReal) BACnetConstructedDataMaximumValueBuilder
	// WithMaximumValue adds MaximumValue (property field)
	WithMaximumValue(BACnetApplicationTagReal) BACnetConstructedDataMaximumValueBuilder
	// WithMaximumValueBuilder adds MaximumValue (property field) which is build by the builder
	WithMaximumValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataMaximumValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataMaximumValue or returns an error if something is wrong
	Build() (BACnetConstructedDataMaximumValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataMaximumValue
}

// NewBACnetConstructedDataMaximumValueBuilder() creates a BACnetConstructedDataMaximumValueBuilder
func NewBACnetConstructedDataMaximumValueBuilder() BACnetConstructedDataMaximumValueBuilder {
	return &_BACnetConstructedDataMaximumValueBuilder{_BACnetConstructedDataMaximumValue: new(_BACnetConstructedDataMaximumValue)}
}

type _BACnetConstructedDataMaximumValueBuilder struct {
	*_BACnetConstructedDataMaximumValue

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataMaximumValueBuilder) = (*_BACnetConstructedDataMaximumValueBuilder)(nil)

func (b *_BACnetConstructedDataMaximumValueBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataMaximumValue
}

func (b *_BACnetConstructedDataMaximumValueBuilder) WithMandatoryFields(maximumValue BACnetApplicationTagReal) BACnetConstructedDataMaximumValueBuilder {
	return b.WithMaximumValue(maximumValue)
}

func (b *_BACnetConstructedDataMaximumValueBuilder) WithMaximumValue(maximumValue BACnetApplicationTagReal) BACnetConstructedDataMaximumValueBuilder {
	b.MaximumValue = maximumValue
	return b
}

func (b *_BACnetConstructedDataMaximumValueBuilder) WithMaximumValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataMaximumValueBuilder {
	builder := builderSupplier(b.MaximumValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.MaximumValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataMaximumValueBuilder) Build() (BACnetConstructedDataMaximumValue, error) {
	if b.MaximumValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'maximumValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataMaximumValue.deepCopy(), nil
}

func (b *_BACnetConstructedDataMaximumValueBuilder) MustBuild() BACnetConstructedDataMaximumValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataMaximumValueBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataMaximumValueBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataMaximumValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataMaximumValueBuilder().(*_BACnetConstructedDataMaximumValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataMaximumValueBuilder creates a BACnetConstructedDataMaximumValueBuilder
func (b *_BACnetConstructedDataMaximumValue) CreateBACnetConstructedDataMaximumValueBuilder() BACnetConstructedDataMaximumValueBuilder {
	if b == nil {
		return NewBACnetConstructedDataMaximumValueBuilder()
	}
	return &_BACnetConstructedDataMaximumValueBuilder{_BACnetConstructedDataMaximumValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataMaximumValue) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataMaximumValue) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_MAXIMUM_VALUE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataMaximumValue) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataMaximumValue) GetMaximumValue() BACnetApplicationTagReal {
	return m.MaximumValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataMaximumValue) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetMaximumValue())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataMaximumValue(structType any) BACnetConstructedDataMaximumValue {
	if casted, ok := structType.(BACnetConstructedDataMaximumValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataMaximumValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataMaximumValue) GetTypeName() string {
	return "BACnetConstructedDataMaximumValue"
}

func (m *_BACnetConstructedDataMaximumValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (maximumValue)
	lengthInBits += m.MaximumValue.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataMaximumValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataMaximumValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataMaximumValue BACnetConstructedDataMaximumValue, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataMaximumValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataMaximumValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	maximumValue, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "maximumValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'maximumValue' field"))
	}
	m.MaximumValue = maximumValue

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), maximumValue)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataMaximumValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataMaximumValue")
	}

	return m, nil
}

func (m *_BACnetConstructedDataMaximumValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataMaximumValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataMaximumValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataMaximumValue")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "maximumValue", m.GetMaximumValue(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'maximumValue' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataMaximumValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataMaximumValue")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataMaximumValue) IsBACnetConstructedDataMaximumValue() {}

func (m *_BACnetConstructedDataMaximumValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataMaximumValue) deepCopy() *_BACnetConstructedDataMaximumValue {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataMaximumValueCopy := &_BACnetConstructedDataMaximumValue{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.MaximumValue),
	}
	_BACnetConstructedDataMaximumValueCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataMaximumValueCopy
}

func (m *_BACnetConstructedDataMaximumValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
