/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPriorityValueEnumerated is the corresponding interface of BACnetPriorityValueEnumerated
type BACnetPriorityValueEnumerated interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPriorityValue
	// GetEnumeratedValue returns EnumeratedValue (property field)
	GetEnumeratedValue() BACnetApplicationTagEnumerated
	// IsBACnetPriorityValueEnumerated is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPriorityValueEnumerated()
	// CreateBuilder creates a BACnetPriorityValueEnumeratedBuilder
	CreateBACnetPriorityValueEnumeratedBuilder() BACnetPriorityValueEnumeratedBuilder
}

// _BACnetPriorityValueEnumerated is the data-structure of this message
type _BACnetPriorityValueEnumerated struct {
	BACnetPriorityValueContract
	EnumeratedValue BACnetApplicationTagEnumerated
}

var _ BACnetPriorityValueEnumerated = (*_BACnetPriorityValueEnumerated)(nil)
var _ BACnetPriorityValueRequirements = (*_BACnetPriorityValueEnumerated)(nil)

// NewBACnetPriorityValueEnumerated factory function for _BACnetPriorityValueEnumerated
func NewBACnetPriorityValueEnumerated(peekedTagHeader BACnetTagHeader, enumeratedValue BACnetApplicationTagEnumerated, objectTypeArgument BACnetObjectType) *_BACnetPriorityValueEnumerated {
	if enumeratedValue == nil {
		panic("enumeratedValue of type BACnetApplicationTagEnumerated for BACnetPriorityValueEnumerated must not be nil")
	}
	_result := &_BACnetPriorityValueEnumerated{
		BACnetPriorityValueContract: NewBACnetPriorityValue(peekedTagHeader, objectTypeArgument),
		EnumeratedValue:             enumeratedValue,
	}
	_result.BACnetPriorityValueContract.(*_BACnetPriorityValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPriorityValueEnumeratedBuilder is a builder for BACnetPriorityValueEnumerated
type BACnetPriorityValueEnumeratedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(enumeratedValue BACnetApplicationTagEnumerated) BACnetPriorityValueEnumeratedBuilder
	// WithEnumeratedValue adds EnumeratedValue (property field)
	WithEnumeratedValue(BACnetApplicationTagEnumerated) BACnetPriorityValueEnumeratedBuilder
	// WithEnumeratedValueBuilder adds EnumeratedValue (property field) which is build by the builder
	WithEnumeratedValueBuilder(func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetPriorityValueEnumeratedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPriorityValueBuilder
	// Build builds the BACnetPriorityValueEnumerated or returns an error if something is wrong
	Build() (BACnetPriorityValueEnumerated, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPriorityValueEnumerated
}

// NewBACnetPriorityValueEnumeratedBuilder() creates a BACnetPriorityValueEnumeratedBuilder
func NewBACnetPriorityValueEnumeratedBuilder() BACnetPriorityValueEnumeratedBuilder {
	return &_BACnetPriorityValueEnumeratedBuilder{_BACnetPriorityValueEnumerated: new(_BACnetPriorityValueEnumerated)}
}

type _BACnetPriorityValueEnumeratedBuilder struct {
	*_BACnetPriorityValueEnumerated

	parentBuilder *_BACnetPriorityValueBuilder

	collectedErr []error
}

var _ (BACnetPriorityValueEnumeratedBuilder) = (*_BACnetPriorityValueEnumeratedBuilder)(nil)

func (b *_BACnetPriorityValueEnumeratedBuilder) setParent(contract BACnetPriorityValueContract) {
	b.BACnetPriorityValueContract = contract
	contract.(*_BACnetPriorityValue)._SubType = b._BACnetPriorityValueEnumerated
}

func (b *_BACnetPriorityValueEnumeratedBuilder) WithMandatoryFields(enumeratedValue BACnetApplicationTagEnumerated) BACnetPriorityValueEnumeratedBuilder {
	return b.WithEnumeratedValue(enumeratedValue)
}

func (b *_BACnetPriorityValueEnumeratedBuilder) WithEnumeratedValue(enumeratedValue BACnetApplicationTagEnumerated) BACnetPriorityValueEnumeratedBuilder {
	b.EnumeratedValue = enumeratedValue
	return b
}

func (b *_BACnetPriorityValueEnumeratedBuilder) WithEnumeratedValueBuilder(builderSupplier func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetPriorityValueEnumeratedBuilder {
	builder := builderSupplier(b.EnumeratedValue.CreateBACnetApplicationTagEnumeratedBuilder())
	var err error
	b.EnumeratedValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagEnumeratedBuilder failed"))
	}
	return b
}

func (b *_BACnetPriorityValueEnumeratedBuilder) Build() (BACnetPriorityValueEnumerated, error) {
	if b.EnumeratedValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'enumeratedValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPriorityValueEnumerated.deepCopy(), nil
}

func (b *_BACnetPriorityValueEnumeratedBuilder) MustBuild() BACnetPriorityValueEnumerated {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPriorityValueEnumeratedBuilder) Done() BACnetPriorityValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPriorityValueBuilder().(*_BACnetPriorityValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPriorityValueEnumeratedBuilder) buildForBACnetPriorityValue() (BACnetPriorityValue, error) {
	return b.Build()
}

func (b *_BACnetPriorityValueEnumeratedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPriorityValueEnumeratedBuilder().(*_BACnetPriorityValueEnumeratedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPriorityValueEnumeratedBuilder creates a BACnetPriorityValueEnumeratedBuilder
func (b *_BACnetPriorityValueEnumerated) CreateBACnetPriorityValueEnumeratedBuilder() BACnetPriorityValueEnumeratedBuilder {
	if b == nil {
		return NewBACnetPriorityValueEnumeratedBuilder()
	}
	return &_BACnetPriorityValueEnumeratedBuilder{_BACnetPriorityValueEnumerated: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPriorityValueEnumerated) GetParent() BACnetPriorityValueContract {
	return m.BACnetPriorityValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPriorityValueEnumerated) GetEnumeratedValue() BACnetApplicationTagEnumerated {
	return m.EnumeratedValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPriorityValueEnumerated(structType any) BACnetPriorityValueEnumerated {
	if casted, ok := structType.(BACnetPriorityValueEnumerated); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPriorityValueEnumerated); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPriorityValueEnumerated) GetTypeName() string {
	return "BACnetPriorityValueEnumerated"
}

func (m *_BACnetPriorityValueEnumerated) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPriorityValueContract.(*_BACnetPriorityValue).getLengthInBits(ctx))

	// Simple field (enumeratedValue)
	lengthInBits += m.EnumeratedValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPriorityValueEnumerated) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPriorityValueEnumerated) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPriorityValue, objectTypeArgument BACnetObjectType) (__bACnetPriorityValueEnumerated BACnetPriorityValueEnumerated, err error) {
	m.BACnetPriorityValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPriorityValueEnumerated"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPriorityValueEnumerated")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	enumeratedValue, err := ReadSimpleField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", ReadComplex[BACnetApplicationTagEnumerated](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagEnumerated](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enumeratedValue' field"))
	}
	m.EnumeratedValue = enumeratedValue

	if closeErr := readBuffer.CloseContext("BACnetPriorityValueEnumerated"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPriorityValueEnumerated")
	}

	return m, nil
}

func (m *_BACnetPriorityValueEnumerated) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPriorityValueEnumerated) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPriorityValueEnumerated"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPriorityValueEnumerated")
		}

		if err := WriteSimpleField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", m.GetEnumeratedValue(), WriteComplex[BACnetApplicationTagEnumerated](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'enumeratedValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPriorityValueEnumerated"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPriorityValueEnumerated")
		}
		return nil
	}
	return m.BACnetPriorityValueContract.(*_BACnetPriorityValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPriorityValueEnumerated) IsBACnetPriorityValueEnumerated() {}

func (m *_BACnetPriorityValueEnumerated) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPriorityValueEnumerated) deepCopy() *_BACnetPriorityValueEnumerated {
	if m == nil {
		return nil
	}
	_BACnetPriorityValueEnumeratedCopy := &_BACnetPriorityValueEnumerated{
		m.BACnetPriorityValueContract.(*_BACnetPriorityValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagEnumerated](m.EnumeratedValue),
	}
	_BACnetPriorityValueEnumeratedCopy.BACnetPriorityValueContract.(*_BACnetPriorityValue)._SubType = m
	return _BACnetPriorityValueEnumeratedCopy
}

func (m *_BACnetPriorityValueEnumerated) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
