/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// IdentifyReplyCommandFirmwareVersion is the corresponding interface of IdentifyReplyCommandFirmwareVersion
type IdentifyReplyCommandFirmwareVersion interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	IdentifyReplyCommand
	// GetFirmwareVersion returns FirmwareVersion (property field)
	GetFirmwareVersion() string
	// IsIdentifyReplyCommandFirmwareVersion is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsIdentifyReplyCommandFirmwareVersion()
	// CreateBuilder creates a IdentifyReplyCommandFirmwareVersionBuilder
	CreateIdentifyReplyCommandFirmwareVersionBuilder() IdentifyReplyCommandFirmwareVersionBuilder
}

// _IdentifyReplyCommandFirmwareVersion is the data-structure of this message
type _IdentifyReplyCommandFirmwareVersion struct {
	IdentifyReplyCommandContract
	FirmwareVersion string
}

var _ IdentifyReplyCommandFirmwareVersion = (*_IdentifyReplyCommandFirmwareVersion)(nil)
var _ IdentifyReplyCommandRequirements = (*_IdentifyReplyCommandFirmwareVersion)(nil)

// NewIdentifyReplyCommandFirmwareVersion factory function for _IdentifyReplyCommandFirmwareVersion
func NewIdentifyReplyCommandFirmwareVersion(firmwareVersion string, numBytes uint8) *_IdentifyReplyCommandFirmwareVersion {
	_result := &_IdentifyReplyCommandFirmwareVersion{
		IdentifyReplyCommandContract: NewIdentifyReplyCommand(numBytes),
		FirmwareVersion:              firmwareVersion,
	}
	_result.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// IdentifyReplyCommandFirmwareVersionBuilder is a builder for IdentifyReplyCommandFirmwareVersion
type IdentifyReplyCommandFirmwareVersionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(firmwareVersion string) IdentifyReplyCommandFirmwareVersionBuilder
	// WithFirmwareVersion adds FirmwareVersion (property field)
	WithFirmwareVersion(string) IdentifyReplyCommandFirmwareVersionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() IdentifyReplyCommandBuilder
	// Build builds the IdentifyReplyCommandFirmwareVersion or returns an error if something is wrong
	Build() (IdentifyReplyCommandFirmwareVersion, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() IdentifyReplyCommandFirmwareVersion
}

// NewIdentifyReplyCommandFirmwareVersionBuilder() creates a IdentifyReplyCommandFirmwareVersionBuilder
func NewIdentifyReplyCommandFirmwareVersionBuilder() IdentifyReplyCommandFirmwareVersionBuilder {
	return &_IdentifyReplyCommandFirmwareVersionBuilder{_IdentifyReplyCommandFirmwareVersion: new(_IdentifyReplyCommandFirmwareVersion)}
}

type _IdentifyReplyCommandFirmwareVersionBuilder struct {
	*_IdentifyReplyCommandFirmwareVersion

	parentBuilder *_IdentifyReplyCommandBuilder

	collectedErr []error
}

var _ (IdentifyReplyCommandFirmwareVersionBuilder) = (*_IdentifyReplyCommandFirmwareVersionBuilder)(nil)

func (b *_IdentifyReplyCommandFirmwareVersionBuilder) setParent(contract IdentifyReplyCommandContract) {
	b.IdentifyReplyCommandContract = contract
	contract.(*_IdentifyReplyCommand)._SubType = b._IdentifyReplyCommandFirmwareVersion
}

func (b *_IdentifyReplyCommandFirmwareVersionBuilder) WithMandatoryFields(firmwareVersion string) IdentifyReplyCommandFirmwareVersionBuilder {
	return b.WithFirmwareVersion(firmwareVersion)
}

func (b *_IdentifyReplyCommandFirmwareVersionBuilder) WithFirmwareVersion(firmwareVersion string) IdentifyReplyCommandFirmwareVersionBuilder {
	b.FirmwareVersion = firmwareVersion
	return b
}

func (b *_IdentifyReplyCommandFirmwareVersionBuilder) Build() (IdentifyReplyCommandFirmwareVersion, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._IdentifyReplyCommandFirmwareVersion.deepCopy(), nil
}

func (b *_IdentifyReplyCommandFirmwareVersionBuilder) MustBuild() IdentifyReplyCommandFirmwareVersion {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_IdentifyReplyCommandFirmwareVersionBuilder) Done() IdentifyReplyCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewIdentifyReplyCommandBuilder().(*_IdentifyReplyCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_IdentifyReplyCommandFirmwareVersionBuilder) buildForIdentifyReplyCommand() (IdentifyReplyCommand, error) {
	return b.Build()
}

func (b *_IdentifyReplyCommandFirmwareVersionBuilder) DeepCopy() any {
	_copy := b.CreateIdentifyReplyCommandFirmwareVersionBuilder().(*_IdentifyReplyCommandFirmwareVersionBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateIdentifyReplyCommandFirmwareVersionBuilder creates a IdentifyReplyCommandFirmwareVersionBuilder
func (b *_IdentifyReplyCommandFirmwareVersion) CreateIdentifyReplyCommandFirmwareVersionBuilder() IdentifyReplyCommandFirmwareVersionBuilder {
	if b == nil {
		return NewIdentifyReplyCommandFirmwareVersionBuilder()
	}
	return &_IdentifyReplyCommandFirmwareVersionBuilder{_IdentifyReplyCommandFirmwareVersion: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_IdentifyReplyCommandFirmwareVersion) GetAttribute() Attribute {
	return Attribute_FirmwareVersion
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_IdentifyReplyCommandFirmwareVersion) GetParent() IdentifyReplyCommandContract {
	return m.IdentifyReplyCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_IdentifyReplyCommandFirmwareVersion) GetFirmwareVersion() string {
	return m.FirmwareVersion
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastIdentifyReplyCommandFirmwareVersion(structType any) IdentifyReplyCommandFirmwareVersion {
	if casted, ok := structType.(IdentifyReplyCommandFirmwareVersion); ok {
		return casted
	}
	if casted, ok := structType.(*IdentifyReplyCommandFirmwareVersion); ok {
		return *casted
	}
	return nil
}

func (m *_IdentifyReplyCommandFirmwareVersion) GetTypeName() string {
	return "IdentifyReplyCommandFirmwareVersion"
}

func (m *_IdentifyReplyCommandFirmwareVersion) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).getLengthInBits(ctx))

	// Simple field (firmwareVersion)
	lengthInBits += 64

	return lengthInBits
}

func (m *_IdentifyReplyCommandFirmwareVersion) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_IdentifyReplyCommandFirmwareVersion) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_IdentifyReplyCommand, attribute Attribute, numBytes uint8) (__identifyReplyCommandFirmwareVersion IdentifyReplyCommandFirmwareVersion, err error) {
	m.IdentifyReplyCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("IdentifyReplyCommandFirmwareVersion"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for IdentifyReplyCommandFirmwareVersion")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	firmwareVersion, err := ReadSimpleField(ctx, "firmwareVersion", ReadString(readBuffer, uint32(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'firmwareVersion' field"))
	}
	m.FirmwareVersion = firmwareVersion

	if closeErr := readBuffer.CloseContext("IdentifyReplyCommandFirmwareVersion"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for IdentifyReplyCommandFirmwareVersion")
	}

	return m, nil
}

func (m *_IdentifyReplyCommandFirmwareVersion) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_IdentifyReplyCommandFirmwareVersion) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("IdentifyReplyCommandFirmwareVersion"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for IdentifyReplyCommandFirmwareVersion")
		}

		if err := WriteSimpleField[string](ctx, "firmwareVersion", m.GetFirmwareVersion(), WriteString(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'firmwareVersion' field")
		}

		if popErr := writeBuffer.PopContext("IdentifyReplyCommandFirmwareVersion"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for IdentifyReplyCommandFirmwareVersion")
		}
		return nil
	}
	return m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_IdentifyReplyCommandFirmwareVersion) IsIdentifyReplyCommandFirmwareVersion() {}

func (m *_IdentifyReplyCommandFirmwareVersion) DeepCopy() any {
	return m.deepCopy()
}

func (m *_IdentifyReplyCommandFirmwareVersion) deepCopy() *_IdentifyReplyCommandFirmwareVersion {
	if m == nil {
		return nil
	}
	_IdentifyReplyCommandFirmwareVersionCopy := &_IdentifyReplyCommandFirmwareVersion{
		m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).deepCopy(),
		m.FirmwareVersion,
	}
	_IdentifyReplyCommandFirmwareVersionCopy.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = m
	return _IdentifyReplyCommandFirmwareVersionCopy
}

func (m *_IdentifyReplyCommandFirmwareVersion) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
