/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * SubscriptionPropertiesData
 */
@JsonPropertyOrder({
  SubscriptionPropertiesData.JSON_PROPERTY_ID,
  SubscriptionPropertiesData.JSON_PROPERTY_KEEPALIVE_INTERVAL,
  SubscriptionPropertiesData.JSON_PROPERTY_PUBLISH_INTERVAL,
  SubscriptionPropertiesData.JSON_PROPERTY_RULES,
  SubscriptionPropertiesData.JSON_PROPERTY_ERROR_INTERVAL
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class SubscriptionPropertiesData {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_KEEPALIVE_INTERVAL = "keepaliveInterval";
  private Integer keepaliveInterval = 60000;

  public static final String JSON_PROPERTY_PUBLISH_INTERVAL = "publishInterval";
  private Integer publishInterval = 1000;

  public static final String JSON_PROPERTY_RULES = "rules";
  private List<CommDatalayerProperty> rules = new ArrayList<>();

  public static final String JSON_PROPERTY_ERROR_INTERVAL = "errorInterval";
  private Integer errorInterval = 10000;

  public SubscriptionPropertiesData() {
  }

  public SubscriptionPropertiesData id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * User identification for subscribtion. Use it update and dispose the old subscription
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public SubscriptionPropertiesData keepaliveInterval(Integer keepaliveInterval) {
    
    this.keepaliveInterval = keepaliveInterval;
    return this;
  }

   /**
   * keepalive in milli seconds for subscription time in seconds the subscriptions
   * minimum: 0
   * maximum: 4294967295
   * @return keepaliveInterval
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_KEEPALIVE_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getKeepaliveInterval() {
    return keepaliveInterval;
  }


  @JsonProperty(JSON_PROPERTY_KEEPALIVE_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeepaliveInterval(Integer keepaliveInterval) {
    this.keepaliveInterval = keepaliveInterval;
  }


  public SubscriptionPropertiesData publishInterval(Integer publishInterval) {
    
    this.publishInterval = publishInterval;
    return this;
  }

   /**
   * time in milli seconds for upper limit of publish messages to not get flooded with new messages
   * minimum: 0
   * maximum: 4294967295
   * @return publishInterval
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PUBLISH_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPublishInterval() {
    return publishInterval;
  }


  @JsonProperty(JSON_PROPERTY_PUBLISH_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublishInterval(Integer publishInterval) {
    this.publishInterval = publishInterval;
  }


  public SubscriptionPropertiesData rules(List<CommDatalayerProperty> rules) {
    
    this.rules = rules;
    return this;
  }

  public SubscriptionPropertiesData addRulesItem(CommDatalayerProperty rulesItem) {
    if (this.rules == null) {
      this.rules = new ArrayList<>();
    }
    this.rules.add(rulesItem);
    return this;
  }

   /**
   * Additional rules for subscription
   * @return rules
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CommDatalayerProperty> getRules() {
    return rules;
  }


  @JsonProperty(JSON_PROPERTY_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRules(List<CommDatalayerProperty> rules) {
    this.rules = rules;
  }


  public SubscriptionPropertiesData errorInterval(Integer errorInterval) {
    
    this.errorInterval = errorInterval;
    return this;
  }

   /**
   * time in milli seconds to re-read data if an error was received for a node
   * minimum: 0
   * maximum: 4294967295
   * @return errorInterval
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getErrorInterval() {
    return errorInterval;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorInterval(Integer errorInterval) {
    this.errorInterval = errorInterval;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubscriptionPropertiesData subscriptionPropertiesData = (SubscriptionPropertiesData) o;
    return Objects.equals(this.id, subscriptionPropertiesData.id) &&
        Objects.equals(this.keepaliveInterval, subscriptionPropertiesData.keepaliveInterval) &&
        Objects.equals(this.publishInterval, subscriptionPropertiesData.publishInterval) &&
        Objects.equals(this.rules, subscriptionPropertiesData.rules) &&
        Objects.equals(this.errorInterval, subscriptionPropertiesData.errorInterval);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, keepaliveInterval, publishInterval, rules, errorInterval);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubscriptionPropertiesData {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    keepaliveInterval: ").append(toIndentedString(keepaliveInterval)).append("\n");
    sb.append("    publishInterval: ").append(toIndentedString(publishInterval)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("    errorInterval: ").append(toIndentedString(errorInterval)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `keepaliveInterval` to the URL query string
    if (getKeepaliveInterval() != null) {
      try {
        joiner.add(String.format("%skeepaliveInterval%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getKeepaliveInterval()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `publishInterval` to the URL query string
    if (getPublishInterval() != null) {
      try {
        joiner.add(String.format("%spublishInterval%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPublishInterval()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rules` to the URL query string
    if (getRules() != null) {
      for (int i = 0; i < getRules().size(); i++) {
        if (getRules().get(i) != null) {
          joiner.add(getRules().get(i).toUrlQueryString(String.format("%srules%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `errorInterval` to the URL query string
    if (getErrorInterval() != null) {
      try {
        joiner.add(String.format("%serrorInterval%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorInterval()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

