/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.topics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface TopicCompactionStrategy<T> {
    public static final String TABLE_VIEW_TAG = "table-view";
    public static final Map<String, TopicCompactionStrategy> INSTANCES = new ConcurrentHashMap<String, TopicCompactionStrategy>();

    public Schema<T> getSchema();

    public boolean shouldKeepLeft(T var1, T var2);

    default public void handleSkippedMessage(String key, T cur) {
    }

    public static TopicCompactionStrategy load(String tag, String topicCompactionStrategyClassName) {
        if (topicCompactionStrategyClassName == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(topicCompactionStrategyClassName);
            TopicCompactionStrategy instance = (TopicCompactionStrategy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            INSTANCES.put(tag, instance);
            return instance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error when loading topic compaction strategy: " + topicCompactionStrategyClassName, e);
        }
    }

    public static TopicCompactionStrategy getInstance(String tag) {
        return INSTANCES.get(tag);
    }
}

