/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.attribute;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AttributeParser {
    public static Map<String, String> parseToMap(String attributesModification) {
        String[] kvs;
        if (Strings.isNullOrEmpty((String)attributesModification)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        String arraySeparator = ",";
        String kvSeparator = "=";
        for (String kv : kvs = attributesModification.split(arraySeparator)) {
            String old;
            String value;
            String key;
            if (kv.contains(kvSeparator)) {
                key = kv.split(kvSeparator)[0];
                value = kv.split(kvSeparator)[1];
                if (!key.contains("+")) {
                    throw new RuntimeException("add/alter attribute format is wrong: " + key);
                }
            } else {
                key = kv;
                value = "";
                if (!key.contains("-")) {
                    throw new RuntimeException("delete attribute format is wrong: " + key);
                }
            }
            if ((old = attributes.put(key, value)) == null) continue;
            throw new RuntimeException("key duplication: " + key);
        }
        return attributes;
    }

    public static String parseToString(Map<String, String> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return "";
        }
        ArrayList<String> kvs = new ArrayList<String>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String value = entry.getValue();
            if (Strings.isNullOrEmpty((String)value)) {
                kvs.add(entry.getKey());
                continue;
            }
            kvs.add(entry.getKey() + "=" + entry.getValue());
        }
        return Joiner.on((String)",").join(kvs);
    }
}

