/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.benchmark;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.example.benchmark.AclClient;
import org.apache.rocketmq.example.benchmark.Snapshot;
import org.apache.rocketmq.example.benchmark.StatsBenchmarkTProducer;
import org.apache.rocketmq.example.benchmark.TransactionListenerImpl;
import org.apache.rocketmq.example.benchmark.TxSendConfig;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.SerializeType;
import org.apache.rocketmq.srvutil.ServerUtil;

public class TransactionProducer {
    private static final long START_TIME = System.currentTimeMillis();
    private static final LongAdder MSG_COUNT = new LongAdder();
    static final int MAX_CHECK_RESULT_IN_MSG = 20;

    public static void main(String[] args) throws MQClientException, UnsupportedEncodingException {
        System.setProperty("rocketmq.serialize.type", SerializeType.ROCKETMQ.name());
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        CommandLine commandLine = ServerUtil.parseCmdLine((String)"TransactionProducer", (String[])args, (Options)TransactionProducer.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
        final TxSendConfig config = new TxSendConfig();
        config.topic = commandLine.hasOption('t') ? commandLine.getOptionValue('t').trim() : "BenchmarkTest";
        config.threadCount = commandLine.hasOption('w') ? Integer.parseInt(commandLine.getOptionValue('w')) : 32;
        config.messageSize = commandLine.hasOption('s') ? Integer.parseInt(commandLine.getOptionValue('s')) : 2048;
        config.sendRollbackRate = commandLine.hasOption("sr") ? Double.parseDouble(commandLine.getOptionValue("sr")) : 0.0;
        config.sendUnknownRate = commandLine.hasOption("su") ? Double.parseDouble(commandLine.getOptionValue("su")) : 0.0;
        config.checkRollbackRate = commandLine.hasOption("cr") ? Double.parseDouble(commandLine.getOptionValue("cr")) : 0.0;
        config.checkUnknownRate = commandLine.hasOption("cu") ? Double.parseDouble(commandLine.getOptionValue("cu")) : 0.0;
        config.batchId = commandLine.hasOption("b") ? Long.parseLong(commandLine.getOptionValue("b")) : System.currentTimeMillis();
        config.sendInterval = commandLine.hasOption("i") ? Integer.parseInt(commandLine.getOptionValue("i")) : 0;
        config.aclEnable = commandLine.hasOption('a') && Boolean.parseBoolean(commandLine.getOptionValue('a'));
        config.msgTraceEnable = commandLine.hasOption('m') && Boolean.parseBoolean(commandLine.getOptionValue('m'));
        ExecutorService sendThreadPool = Executors.newFixedThreadPool(config.threadCount);
        final StatsBenchmarkTProducer statsBenchmark = new StatsBenchmarkTProducer();
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("BenchmarkTimerThread-%d").daemon(true).build());
        final LinkedList snapshotList = new LinkedList();
        executorService.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                snapshotList.addLast(statsBenchmark.createSnapshot());
                while (snapshotList.size() > 10) {
                    snapshotList.removeFirst();
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        executorService.scheduleAtFixedRate(new TimerTask(){

            private void printStats() {
                if (snapshotList.size() >= 10) {
                    Snapshot begin = (Snapshot)snapshotList.getFirst();
                    Snapshot end = (Snapshot)snapshotList.getLast();
                    long sendCount = end.sendRequestSuccessCount - begin.sendRequestSuccessCount + (end.sendRequestFailedCount - begin.sendRequestFailedCount);
                    long sendTps = sendCount * 1000L / (end.endTime - begin.endTime);
                    double averageRT = (double)(end.sendMessageTimeTotal - begin.sendMessageTimeTotal) / (double)(end.sendRequestSuccessCount - begin.sendRequestSuccessCount);
                    long failCount = end.sendRequestFailedCount - begin.sendRequestFailedCount;
                    long checkCount = end.checkCount - begin.checkCount;
                    long unexpectedCheck = end.unexpectedCheckCount - begin.unexpectedCheckCount;
                    long dupCheck = end.duplicatedCheck - begin.duplicatedCheck;
                    System.out.printf("Current Time: %s | Send TPS: %5d | Max RT(ms): %5d | AVG RT(ms): %3.1f | Send Failed: %d | Check: %d | UnexpectedCheck: %d | DuplicatedCheck: %d%n", UtilAll.timeMillisToHumanString2((long)System.currentTimeMillis()), sendTps, statsBenchmark.getSendMessageMaxRT().get(), averageRT, failCount, checkCount, unexpectedCheck, dupCheck);
                    statsBenchmark.getSendMessageMaxRT().set(0L);
                }
            }

            @Override
            public void run() {
                try {
                    this.printStats();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
        RPCHook rpcHook = null;
        if (config.aclEnable) {
            String ak = commandLine.hasOption("ak") ? String.valueOf(commandLine.getOptionValue("ak")) : "rocketmq2";
            String sk = commandLine.hasOption("sk") ? String.valueOf(commandLine.getOptionValue("sk")) : "12345678";
            rpcHook = AclClient.getAclRPCHook(ak, sk);
        }
        TransactionListenerImpl transactionCheckListener = new TransactionListenerImpl(statsBenchmark, config);
        final TransactionMQProducer producer = new TransactionMQProducer(null, "benchmark_transaction_producer", rpcHook, config.msgTraceEnable, null);
        producer.setInstanceName(Long.toString(System.currentTimeMillis()));
        producer.setTransactionListener((TransactionListener)transactionCheckListener);
        producer.setDefaultTopicQueueNums(1000);
        if (commandLine.hasOption('n')) {
            String ns = commandLine.getOptionValue('n');
            producer.setNamesrvAddr(ns);
        }
        producer.start();
        for (int i = 0; i < config.threadCount; ++i) {
            sendThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        boolean success = false;
                        long beginTimestamp = System.currentTimeMillis();
                        try {
                            TransactionSendResult sendResult = producer.sendMessageInTransaction(TransactionProducer.buildMessage(config), null);
                            success = sendResult != null && sendResult.getSendStatus() == SendStatus.SEND_OK;
                            continue;
                        }
                        catch (Throwable e) {
                            success = false;
                            continue;
                        }
                        finally {
                            boolean updated;
                            long currentRT = System.currentTimeMillis() - beginTimestamp;
                            statsBenchmark.getSendMessageTimeTotal().add(currentRT);
                            long prevMaxRT = statsBenchmark.getSendMessageMaxRT().get();
                            while (currentRT > prevMaxRT && !(updated = statsBenchmark.getSendMessageMaxRT().compareAndSet(prevMaxRT, currentRT))) {
                                prevMaxRT = statsBenchmark.getSendMessageMaxRT().get();
                            }
                            if (success) {
                                statsBenchmark.getSendRequestSuccessCount().increment();
                            } else {
                                statsBenchmark.getSendRequestFailedCount().increment();
                            }
                            if (config.sendInterval <= 0) continue;
                            try {
                                Thread.sleep(config.sendInterval);
                            }
                            catch (InterruptedException updated2) {}
                            continue;
                        }
                        break;
                    }
                }
            });
        }
    }

    private static Message buildMessage(TxSendConfig config) {
        byte[] bs = new byte[config.messageSize];
        ThreadLocalRandom r = ThreadLocalRandom.current();
        r.nextBytes(bs);
        ByteBuffer buf = ByteBuffer.wrap(bs);
        buf.putLong(config.batchId);
        long sendMachineId = START_TIME << 32;
        long count = MSG_COUNT.longValue();
        long msgId = sendMachineId | count;
        MSG_COUNT.increment();
        buf.putLong(msgId);
        if (r.nextDouble() < config.sendRollbackRate) {
            buf.put((byte)LocalTransactionState.ROLLBACK_MESSAGE.ordinal());
        } else if (r.nextDouble() < config.sendUnknownRate) {
            buf.put((byte)LocalTransactionState.UNKNOW.ordinal());
        } else {
            buf.put((byte)LocalTransactionState.COMMIT_MESSAGE.ordinal());
        }
        for (int i = 0; i < 20; ++i) {
            if (r.nextDouble() < config.checkRollbackRate) {
                buf.put((byte)LocalTransactionState.ROLLBACK_MESSAGE.ordinal());
                continue;
            }
            if (r.nextDouble() < config.checkUnknownRate) {
                buf.put((byte)LocalTransactionState.UNKNOW.ordinal());
                continue;
            }
            buf.put((byte)LocalTransactionState.COMMIT_MESSAGE.ordinal());
        }
        Message msg = new Message();
        msg.setTopic(config.topic);
        msg.setBody(bs);
        return msg;
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("w", "threadCount", true, "Thread count, Default: 32");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "messageSize", true, "Message Size, Default: 2048");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "Topic name, Default: BenchmarkTest");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("sr", "send rollback rate", true, "Send rollback rate, Default: 0.0");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("su", "send unknown rate", true, "Send unknown rate, Default: 0.0");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("cr", "check rollback rate", true, "Check rollback rate, Default: 0.0");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("cu", "check unknown rate", true, "Check unknown rate, Default: 0.0");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("b", "test batch id", true, "test batch id, Default: System.currentMillis()");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("i", "send interval", true, "sleep interval in millis between messages, Default: 0");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("a", "aclEnable", true, "Acl Enable, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("ak", "accessKey", true, "Acl access key, Default: 12345678");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("sk", "secretKey", true, "Acl secret key, Default: rocketmq2");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("m", "msgTraceEnable", true, "Message Trace Enable, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }
}

